/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package poker090316;

import java.util.Random;
import java.io.IOException;

/**
 *
 * @author luki
 */
public class Main {

    /**
     * @param args the command line arguments
     */
    public static void zamien(int[] t, int i, int j) {
        int tmp = t[i];
        t[i] = t[j];
        t[j] = tmp;
    }

    public static void zamien(Object[] t, int i, int j) {
        Object tmp = t[i];
        t[i] = t[j];
        t[j] = tmp;
    }

    public static void test1() {
        System.out.println(50 / 4);   //figura
        System.out.println(51 - 4 * (51 / 4));  //kolor
    }

    public static void test2() {
        Player p = new Player();
        p.wezKarte("KH");
        p.wezKarte("AH");
        p.wezKarte("TH");
        p.wezKarte("KS");
        p.wezKarte("DH");
        p.wezKarte("8T");
        p.wezKarte("JH");
        p.policzUklad();
        System.out.println(p.printCards());
        System.out.println(p.printSeq());
        System.out.println(p.printPocket());
    }

    public static void test3() {
        Table t = new Table();
        System.out.println(t.dajKarte());
        System.out.println(t.dajKarte());
        System.out.println(t.dajKarte());
        System.out.println(t.dajKarte());
        System.out.println(t.dajKarte());
//        System.out.println(t.dajKarte());
    }

    public static void test4() {
        Random r = new Random();
        for (int i = 0; i < 10; i++) {
            System.out.println(r.nextLong());
        }
    }

    public static void test5() {
        Table t = new Table();
        Player p1 = new Player();
        Player p2 = new Player();
        int tmp;
        for (int i = 0; i < 2; i++) {
            p1.wezKarte(t.dajKarte());
        }
        for (int i = 0; i < 2; i++) {
            p2.wezKarte(t.dajKarte());
        }
        for (int i = 0; i < 5; i++) {
            tmp = t.dajKarte();
            p1.wezKarte(tmp);
            p2.wezKarte(tmp);
        }
        p1.policzUklad();
        p2.policzUklad();
        System.out.println("P1: " + p1.printCards() + " ma " + p1.printSeq());
        System.out.println("P2: " + p2.printCards() + " ma " + p2.printSeq());
        System.out.println("P1 vs P2 = " + p1.compareTo(p2));
    }

    public static void test6() {
        int liczbaGraczy = 6;
        Table t = new Table();
        Player[] ps = new Player[liczbaGraczy];
        for (int i = 0; i < liczbaGraczy; i++) {
            ps[i] = new Player();
        }
        //rozdaj karty
        int tmp;
        for (int p = 0; p < liczbaGraczy; p++) {
            for (int i = 0; i < 2; i++) {
                ps[p].wezKarte(t.dajKarte());
            }
        }
        for (int i = 0; i < 5; i++) {
            tmp = t.dajKarte();
            for (int p = 0; p < liczbaGraczy; p++) {
                ps[p].wezKarte(tmp);
            }
        }
        //policz uklady
        for (int p = 0; p < liczbaGraczy; p++) {
            ps[p].policzUklad();
        }
        //uloz graczy kolejno
        Player[] psu = new Player[liczbaGraczy];
        for (int p = 0; p < liczbaGraczy; p++) {
            tmp = p;
            psu[tmp] = ps[tmp];
            while (tmp >= 1 && psu[tmp].compareTo(psu[tmp - 1]) > 0) {
                Main.zamien(psu, tmp, tmp - 1);
                tmp--;
            }
        }
        //ranks
        int[] ranks;
        ranks = new int[liczbaGraczy];
        ranks[0] = 0;
        for (int i = 1; i < liczbaGraczy; i++) {
            if (psu[i].compareTo(psu[i - 1]) == 0) {
                ranks[i] = ranks[i - 1];
            } else {
                ranks[i] = i;
            }
        }

        //sprawdz ulozenie
        for (int p = 0; p < liczbaGraczy; p++) {
            System.out.println("R: " + ranks[p] + " Pc: " + psu[p].printPocket() + " P: " + psu[p].printCards() + " ma " + psu[p].printSeq());
        }

    }

    public static void test7(int liczbaGraczy, int max_rank, int loops) {
        int looptimes = loops/liczbaGraczy;
        //int liczbaGraczy = 8;
        Table t = new Table();
        Player[] ps = new Player[liczbaGraczy];
        Player[] psu = new Player[liczbaGraczy];
        int[] ranks = new int[liczbaGraczy];
        boolean[] allin_winner = new boolean[liczbaGraczy];
        boolean[] alliner = new boolean[liczbaGraczy];
        Stats s = new Stats(liczbaGraczy);

        //powolaj graczy
        for (int i = 0; i < liczbaGraczy; i++) {
            ps[i] = new Player();
        }
        //w petli...
        for (int lop = 0; lop < looptimes; lop++) {
            //rozdaj karty
            int tmp;
            for (int p = 0; p < liczbaGraczy; p++) {
                for (int i = 0; i < 2; i++) {
                    ps[p].wezKarte(t.dajKarte());
                }
            }
            for (int i = 0; i < 5; i++) {
                tmp = t.dajKarte();
                for (int p = 0; p < liczbaGraczy; p++) {
                    ps[p].wezKarte(tmp);
                }
            }
            //policz uklady
            for (int p = 0; p < liczbaGraczy; p++) {
                ps[p].policzUklad();
            }
            //uloz graczy kolejno
            for (int p = 0; p < liczbaGraczy; p++) {
                tmp = p;
                psu[tmp] = ps[tmp];
                while (tmp >= 1 && psu[tmp].compareTo(psu[tmp - 1]) > 0) {
                    Main.zamien(psu, tmp, tmp - 1);
                    tmp--;
                }
            }
            //ranks - dla rankingu pocketow
            ranks[0] = 0;
            for (int i = 1; i < liczbaGraczy; i++) {
                if (psu[i].compareTo(psu[i - 1]) == 0) {
                    ranks[i] = ranks[i - 1];
                } else {
                    ranks[i] = i;
                }
            }
            //ranks - dla wchodzacych all-in (tylko z dobra karta)
            int allin_winner_rank = -1;
            int alliners_count = 0;
            int allin_winners_count = 0;
            for (int i = 0; i < liczbaGraczy; i++) {
                allin_winner[i] = false;
                alliner[i] = false;
                if (StatsLib.getPocketRank(psu[i].printPocket(), liczbaGraczy) <= max_rank ) {
                    alliner[i] = true;
                    alliners_count++;
                    if (allin_winner_rank < 0) allin_winner_rank = ranks[i];
                    if (ranks[i] == allin_winner_rank)
                    {
                        allin_winner[i] = true;
                        allin_winners_count++;
                    }
                }
            }
/*
            for(int i = 0; i < liczbaGraczy; i++) {
                System.out.print(ranks[i] + " " + psu[i].printPocket() + " " + psu[i].printCards());
                System.out.println(" " + alliner[i] + " " + allin_winner[i]);
            }
*/
            //zapisz statystyki - dla oblicznaia rankingu pocketow
            for (int p = 0; p < liczbaGraczy; p++) {
                s.add(psu[p].printPocket(), ranks[p]);
            }
            //zapisz statystyki - dla obliczania wartosci oczekiwanej wejscia all-in
            for (int i = 0; i < liczbaGraczy; i++) {
                if (alliner[i]) s.addAllin(psu[i].printPocket(), allin_winner[i], alliners_count, allin_winners_count);
                else {
                    if (ranks[i] > allin_winner_rank) s.addAllin(psu[i].printPocket(), false, alliners_count + 1, allin_winners_count);
                    if (ranks[i] == allin_winner_rank) s.addAllin(psu[i].printPocket(), true, alliners_count + 1, allin_winners_count + 1);
                    if (ranks[i] < allin_winner_rank) s.addAllin(psu[i].printPocket(), true, alliners_count + 1, 1);
                }
            }

            //przygotuj do nastepnej iteracji
            t.reset();
            for (int p = 0; p < liczbaGraczy; p++) {
                ps[p].reset();
            }
        }

        //s.printResults();
        try {
            //s.printResultsToFile("c:/work3/out" + (liczbaGraczy>9?"":"0") + liczbaGraczy);
            s.printResultsToFile2("c:/work3/out" + (liczbaGraczy>9?"":"0") + liczbaGraczy + "_" + max_rank);
        } catch (IOException e)
        {
            System.out.println("Blad pisania do pliku: " + e.toString());
        }
    }

    public static void main(String[] args) {
        //test1();
       /*
        for (int i1 = 2; i1 <= 8; i1++)
            for(int i2 = 10; i2 <= 45; i2+=5)
            {
                System.out.println("Obliczam liczba graczy = " + i1 + ", liczba rak = " + i2);
                test7(i1, i2, 500000);
            }
        */
        test7(8, 30, 10000000);
    /*
     * pomysl
     * 1. rozdaj karty n-graczom
     * 2. ustal kolejnosc rak
     * 3. uzupelnij tabele poket_type probability rank
     * 4. powtarzaj 1-3 wiele razy
     *
     * Player - dostaje karty, ustala uklad
     * Table - rozdaje karty graczom, po dwa pokety i po 5 wspolnych kazdemu
     * Sequence, Card - pomocnicze: nazwy ukladow i kart/kolorow
     */
    }
}
