/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package poker090316;

import exception.MyException;

/**
 *
 * @author luki
 */
public class Card {

    public static final int KIER = 0;
    public static final int KARO = 1;
    public static final int PIK = 2;
    public static final int TREFL = 3;
    public static final int S2 = 0;
    public static final int S3 = 1;
    public static final int S4 = 2;
    public static final int S5 = 3;
    public static final int S6 = 4;
    public static final int S7 = 5;
    public static final int S8 = 6;
    public static final int S9 = 7;
    public static final int BT = 8;
    public static final int BJ = 9;
    public static final int BQ = 10;
    public static final int BK = 11;
    public static final int BA = 12;

    public static int stringToInt(String s) {
        int fig = -1, kol = -1;
        if (s.length() != 2) {
            throw new MyException("Nieznana karta " + s);
        }
        switch (s.charAt(0)) {
            case 'A':
                fig = BA;
                break;
            case 'K':
                fig = BK;
                break;
            case 'D':
                fig = BQ;
                break;
            case 'J':
                fig = BJ;
                break;
            case 'T':
                fig = BT;
                break;
            case '9':
                fig = S9;
                break;
            case '8':
                fig = S8;
                break;
            case '7':
                fig = S7;
                break;
            case '6':
                fig = S6;
                break;
            case '5':
                fig = S5;
                break;
            case '4':
                fig = S4;
                break;
            case '3':
                fig = S3;
                break;
            case '2':
                fig = S2;
                break;
            default:
                throw new MyException("Nieznana figura " + s.charAt(0));
        }
        switch (s.charAt(1)) {
            case 'H':
                kol = KIER;
                break;
            case 'D':
                kol = KARO;
                break;
            case 'S':
                kol = PIK;
                break;
            case 'T':
                kol = TREFL;
                break;
            default:
                throw new MyException("Nieznany kolor " + s.charAt(1));
        }
        return fig * 4 + kol;
    }

    public static String intToStringFig(int x)
    {
        switch (x) {
            case S2: return "2";
            case S3: return "3";
            case S4: return "4";
            case S5: return "5";
            case S6: return "6";
            case S7: return "7";
            case S8: return "8";
            case S9: return "9";
            case BT: return "T";
            case BJ: return "J";
            case BQ: return "Q";
            case BK: return "K";
            case BA: return "A";
            default: throw new MyException("Nieznana figura val=" + x);
        }
    }

    public static String intToStringKol(int x) {
        switch (x) {
            case KIER: return "H";
            case KARO: return "D";
            case PIK: return "S";
            case TREFL: return "T";
            default: throw new MyException("Nieznana kolor val=" + x);
        }
    }

    public static String intToString(int x) {
        return intToStringFig(x/4) + intToStringKol(x - 4 * (x / 4));
    }

}
