/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package poker090316;

import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Collections;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;

/**
 *
 * @author luki
 */
public class Stats {

    private int liczbaGraczy;
    
    class Freqs {
        public int[] ranks;
        private float tmpprob = 0;

        private int allins = 0;
        private int allin_wins = 0;
        private int allin_lost = 0;
        private double val_mean = 0;
        private int[][] alliner_cowinners;
        private int[] allin_checkers;

        Freqs() {
            ranks = new int[liczbaGraczy];
            for (int i = 0; i < liczbaGraczy; i++) ranks[i] = 0;
            allin_checkers = new int[liczbaGraczy];
            for (int i = 0; i < liczbaGraczy; i++) allin_checkers[i] = 0;
            alliner_cowinners = new int[liczbaGraczy][liczbaGraczy];
            for (int i = 0; i < liczbaGraczy; i++)
                for (int j = 0; j < liczbaGraczy; j++)
                    alliner_cowinners[i][j] = 0;
        }

        public void reg(int x) {
            ranks[x]++;
        }

        public void regAllin(boolean win, int all, int winners) {
            allin_checkers[all-1]++;
            double d = (win?(double)all/winners:(double)0) - 1;
            val_mean = val_mean * allins / (allins + 1) + d / (allins + 1);
            allins++;
            if (win) {
                allin_wins++;
                alliner_cowinners[all-1][winners-1]++;
            }
            else allin_lost++;
        }

        public String toString() {
            String result = "";
            for(int i = 0; i < liczbaGraczy; i++) {
                result += (i==0?"":" ") + ranks[i];
            }
            return result;
        }

        public void countProb() {
            if (tmpprob != 0) return;
            int tmp = 0;
            for(int i = 0; i < liczbaGraczy; i++) tmp += ranks[i];
            tmpprob = ((float)ranks[0]) / tmp;
        }

        public String getProbToString() {
            //return Float.toString(tmpprob);
            return String.format("%2.4f", tmpprob);
        }

        public String getWspToString() {
            return Float.toString(tmpprob * liczbaGraczy);
        }

        public String getAllinWins() {
            //return Double.toString(((double)allin_wins / allins));
            return String.format("%2.4f", (double)allin_wins / allins);
        }

        public String getAllinVal() {
            //return Double.toString(val_mean);
            return String.format("%2.4f", val_mean);
        }

        public String getAllinWinsDetails() {
            String res = "";
            if (allins == 0) return "No allins.";
            res = " %lost: " + String.format("%4.2f", (double)allin_lost * 100 / allins);
            res += " %won: " + String.format("%4.2f", (double)allin_wins * 100 / allins);
            if (allin_wins == 0) return res;
            for (int i = 0; i < liczbaGraczy; i++)
                for (int j = 0; j <=i ; j++)
                    res += " (" + i + "." + j + ")=" + String.format("%4.2f", (double)alliner_cowinners[i][j] * 100 / allin_wins);
            return res;
        }

        public String getAllinCheckersDetails() {
            String res = "";
            res = " check:";
            for (int i = 0; i < liczbaGraczy; i++)
                    res += " " + i + "=" + String.format("%4.2f", (double)allin_checkers[i] * 100 / allins);
            return res;
        }

    }

    class MapElement implements Comparable {
        private String type;
        private Freqs freqs;
        
        public MapElement(String s, Freqs f) {
            type = s;
            freqs = f;
            f.countProb();
        }

        public int compareTo(Object o) {
            MapElement m = (MapElement)o;
            //dla pocket ranks
//            if (m.freqs.tmpprob == freqs.tmpprob) return 0;
//            return (m.freqs.tmpprob < freqs.tmpprob?-1:1);
            //dla allin vals
            if (m.freqs.val_mean == freqs.val_mean) return 0;
            return (m.freqs.val_mean < freqs.val_mean?-1:1);
        }

        public String getType(){return type;}
        public Freqs getFreqs(){return freqs;}
    }
    
    private Map<String, Freqs> map;

    public Stats(int n) {
        liczbaGraczy = n;
        map = new HashMap<String, Freqs>();
    }

    public void add(String s, int rank)
    {
        Freqs f = map.get(s);
        if (f == null)
        {
            f = new Freqs();
            f.reg(rank);
            map.put(s, f);
        }
        else
        {
            f.reg(rank);
        }
    }

    public void addAllin(String s, boolean win, int all, int winners) {
        Freqs f = map.get(s);
        if (f == null)
        {
            f = new Freqs();
            f.regAllin(win, all, winners);
            map.put(s, f);
        }
        else
        {
            f.regAllin(win, all, winners);
        }
    }

    public List<MapElement> sortMap() {
        List<MapElement> l = new ArrayList<MapElement>();
        for(String s : map.keySet()) l.add(new MapElement(s, map.get(s)));
        Collections.sort(l);
        return l;
    }
    
    public void printResults() {
        String s;
        Iterator<String> it = map.keySet().iterator();
        while(it.hasNext()) {
            s = it.next();
            System.out.println(s + " " + map.get(s).toString());
        }
    }

    public void printResultsToFile(String filename) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
        List<MapElement> sortedMap = sortMap();
        for(MapElement e : sortedMap) {
            out.write(e.getType() + " " + e.getFreqs().getProbToString() + " " + e.getFreqs().getWspToString() + "\n");
        }
        out.close();
    }

    public void printResultsToFile2(String filename) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
        List<MapElement> sortedMap = sortMap();
        for(MapElement e : sortedMap) {
            out.write(e.getType() + " " + e.getFreqs().getProbToString() + " " + e.getFreqs().getAllinWins() + " " + e.getFreqs().getAllinVal() + " " + e.getFreqs().getAllinWinsDetails() + e.getFreqs().getAllinCheckersDetails()+ "\n");
        }
        out.close();
    }

}
