/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package poker090316;

import exception.MyException;

/**
 *
 * @author luki
 */
public class Player implements Comparable {

    private int[] karty;    //przyznane karty - niekonieczne?
    private int liczbaKart;
    private int[][] kolor;  //karty ulozone kolorami
    private int[] liczbaKoloru;
    private int[] liczbaFigur;  //licznosc kazdej figury
    private int uklad;  //koncowy najlepszy uklad
    private int[] kartyUkladu;  //jakosc koncowego ukladu
    private int liczbaKartUkladu;
    private int[][] seq; //pomocnicze: sekwencja, figura
    private int[] liczbaSeq;
    private boolean wyliczony;

    public Player() {
        karty = new int[7];
        kolor = new int[4][13];
        liczbaKoloru = new int[4];
        liczbaFigur = new int[13];
        kartyUkladu = new int[5]; //uklad, liczbaKartUkladu potem
        seq = new int[4][7];    //sekwencja, figura
        liczbaSeq = new int[4];
        reset();
    }



    public void wezKarte(String s) {
        wezKarte(Card.stringToInt(s));
    }

    public void wezKarte(int k) {
        int kol = k - 4 * (k / 4);
        int fig = k / 4;
        int i, tmp;

        if (liczbaKart >= 7) {
            throw new MyException("Mam juz 7 kart");
        }
        karty[liczbaKart] = k;
        liczbaKart++;

        kolor[kol][liczbaKoloru[kol]] = fig;
        i = liczbaKoloru[kol];
        while ((i >= 1) && (kolor[kol][i] < kolor[kol][i - 1])) {
            Main.zamien(kolor[kol], i, i - 1);
            i--;
        }
        liczbaKoloru[kol]++;
        liczbaFigur[fig]++;
    }

    public void policzUklad() {
        int kolor5 = -1;
        int kolej5 = -1;
        int tmp, tmpmem;

        wyliczony = true;

        if (liczbaKart != 7) {
            throw new MyException("Potrzeba 7 kart, mam " + liczbaKart);
        }

        for (int i = 0; i < 4; i++) {
            if (liczbaKoloru[i] >= 5) {
                kolor5 = i;
            }
            liczbaSeq[i] = 0;
        }

        for (int i = 12; i >= 0; i--) {
            if (liczbaFigur[i] > 0) {
                seq[liczbaFigur[i] - 1][liczbaSeq[liczbaFigur[i] - 1]] = i;
                liczbaSeq[liczbaFigur[i] - 1]++;
            }
        }

        if (liczbaFigur[Card.BA] > 0) {
            tmp = 1;
        } else {
            tmp = 0;
        }

        for (int i = 1; i < 13; i++) {
            if (liczbaFigur[i] > 0 && liczbaFigur[i - 1] > 0) {
                tmp++;
                if (tmp >= 4) {
                    kolej5 = i;
                }
            } else {
                tmp = 0;
            }
        }

        //czy jest poker
        if (kolor5 > -1 && kolej5 > -1) {
            if (kolor[kolor5][0] == Card.S2 && kolor[kolor5][liczbaKoloru[kolor5] - 1] == Card.BA) {
                tmp = 1; //jezeli jest A2...
            } else {
                tmp = 0; //liczba kolejnych kart
            }
            tmpmem = -1; //najwyzsza w kolorze kolejno
            for (int i = 1; i < liczbaKoloru[kolor5]; i++) {
                if (kolor[kolor5][i - 1] + 1 == kolor[kolor5][i]) {
                    tmp++;
                    if (tmp >= 4) {
                        tmpmem = kolor[kolor5][i];
                    }
                } else {
                    tmp = 0;
                }
            }
            if (tmpmem > -1) {
                uklad = Sequence.POKER;
                kartyUkladu[0] = tmpmem;//dla pokera zwracam najwyza do porownan
                liczbaKartUkladu = 1;
                return;
            }
        }

        //czy jest kareta
        if (liczbaSeq[3] > 0) {
            uklad = Sequence.KARETA;
            kartyUkladu[0] = seq[3][0];
            liczbaKartUkladu = 1;
            return;
        }

        //czy jest ful
        if (liczbaSeq[2] > 1) {
            uklad = Sequence.FUL;
            kartyUkladu[0] = seq[2][0];
            kartyUkladu[1] = seq[2][1];
            liczbaKartUkladu = 2;
            return;
        }

        if (liczbaSeq[2] > 0 && liczbaSeq[1] > 0) {
            uklad = Sequence.FUL;
            kartyUkladu[0] = seq[2][0];
            kartyUkladu[1] = seq[1][0];
            liczbaKartUkladu = 2;
            return;
        }

        //czy jest kolor
        if (kolor5 > -1) {
            uklad = Sequence.KOLOR;
            kartyUkladu[0] = kolor[kolor5][liczbaKoloru[kolor5] - 1];
            liczbaKartUkladu = 1;
            return;
        }

        //czy jest kolejnosc
        if (kolej5 > -1) {
            uklad = Sequence.KOLEJNOSC;
            kartyUkladu[0] = kolej5;
            liczbaKartUkladu = 1;
            return;
        }

        //czy jest trojka
        if (liczbaSeq[2] > 0) {
            uklad = Sequence.TRZY;
            kartyUkladu[0] = seq[2][0];
            kartyUkladu[1] = seq[0][0];
            kartyUkladu[2] = seq[0][1];
            liczbaKartUkladu = 3;
            return;
        }
        //czy sa pary
        if (liczbaSeq[1] > 1) {
            uklad = Sequence.PARY;
            kartyUkladu[0] = seq[1][0];
            kartyUkladu[1] = seq[1][1];
            if (liczbaSeq[1] == 3) {
                kartyUkladu[2] = Math.max(seq[1][2], seq[0][0]);
            } else {
                kartyUkladu[2] = seq[0][0];
            }
            liczbaKartUkladu = 3;
            return;
        }

        //czy jest para
        if (liczbaSeq[1] > 0) {
            uklad = Sequence.PARA;
            kartyUkladu[0] = seq[1][0];
            kartyUkladu[1] = seq[0][0];
            kartyUkladu[2] = seq[0][1];
            kartyUkladu[3] = seq[0][2];
            liczbaKartUkladu = 4;
            return;
        }
        uklad = Sequence.KARTA;
        kartyUkladu[0] = seq[0][0];
        kartyUkladu[1] = seq[0][1];
        kartyUkladu[2] = seq[0][2];
        kartyUkladu[3] = seq[0][3];
        kartyUkladu[4] = seq[0][4];
        liczbaKartUkladu = 5;
        return;

    }

    void reset() {
        liczbaKart = 0;
        for (int i = 0; i < 4; i++) {
            liczbaKoloru[i] = 0;
        }
        for (int i = 0; i < 13; i++) {
            liczbaFigur[i] = 0;
        }
        wyliczony = false;
    }

    public int compareTo(Object o) {
        if (!(o instanceof Player)) throw new MyException("Porownanie z nie-Playerem");
        Player p = (Player)o;
        if (!wyliczony) throw new MyException("Najpierw uruchom policzUklad");
        if (!p.wyliczony) throw new MyException("Uruchom policzUklad dla Playera");
        if (uklad < p.uklad) return -1;
        if (uklad > p.uklad) return 1;
        for (int i = 0; i < liczbaKartUkladu; i++)
        {
            if (kartyUkladu[i] < p.kartyUkladu[i]) return -1;
            if (kartyUkladu[i] > p.kartyUkladu[i]) return 1;
        }
        return 0;
    }


    public String printSeq() {
        return Sequence.intToString(uklad, kartyUkladu, liczbaKartUkladu);
    }

    public void printState() {
        System.out.println("Stan");
        for (int i = 0; i < 13; i++) {
            System.out.print(liczbaFigur[i]);
        }
        System.out.println();
    }

    public String printCards() {
        String result = "";
        for (int i = 0; i < liczbaKart; i++) result += (i==0?"":" ") + Card.intToString(karty[i]);
        return result;
    }

    public String printPocket() {
        int k1 = 0, k2 = 0;
        if (karty[0] < karty[1]) {
            k2 = karty[0];
            k1 = karty[1];
        }
        else
        {
            k1 = karty[0];
            k2 = karty[1];            
        }
        if (k1%4 == k2%4) return Card.intToStringFig(k1/4) + Card.intToStringFig(k2/4) + "s";
        else return Card.intToStringFig(k1/4) + Card.intToStringFig(k2/4) + "o";
    }

}
