% Mallorca risk study 2016-12-07

clear
clc

global B_backup;

%% ****************************  loading data  ****************************


EstimOpt.fnameinput = ('data_mallorca_01.mat'); 
DATA = load(EstimOpt.fnameinput);


%% ****************************  data transformations  ****************************

DATA.INC = NaN(size(DATA.INCOME));
DATA.INC(DATA.INCOME == 1) = 500;
DATA.INC(DATA.INCOME == 2) = 1500;
DATA.INC(DATA.INCOME == 3) = 2500;
DATA.INC(DATA.INCOME == 4) = 3500;
DATA.INC(DATA.INCOME == 5) = 4500;
DATA.INC(DATA.INCOME == 6) = 5500;
DATA.INC(DATA.INCOME == 7) = 6500;
DATA.INC(DATA.INCOME == 8) = 7500;


%% ****************************  model specification  ****************************


DATA.Y = DATA.CHOICE;

% jointly:
DATA.Xa = [DATA.ASC, DATA.TYPs==-1, DATA.TYPs==0.5, DATA.NTYPs==-1, DATA.NTYPs==0.5, DATA.WT7, DATA.WT3, DATA.RP2, DATA.RP3, -DATA.PRICEs];
EstimOpt.NamesA = {'Status quo - alternative specific constant';'Typical bird species: 0 -> -10';'Typical bird species: 0 -> +5';'Non-typical bird species: 0 -> -10';'Non-typical bird species: 0 -> +5';'Waiting time reduced: 15 -> 7';'Waiting time reduced: 15 -> 3';'Number of rest-stop benches: doubled'; 'Number of rest-stop benches: tripled'; '- Cost (10 EUR)'};

% separately:
% DATA.Xa = [DATA.ASC,(DATA.TYPs==-1).*(DATA.TREAT==0),(DATA.TYPs==-1).*(DATA.TREAT==1),(DATA.TYPs==0.5).*(DATA.TREAT==0),(DATA.TYPs==0.5).*(DATA.TREAT==1), DATA.NTYPs==-1, DATA.NTYPs==0.5,  DATA.WT7, DATA.WT3, DATA.RP2, DATA.RP3, -DATA.PRICEs];
% EstimOpt.NamesA = {'Status quo - alternative specific constant';'Typical bird species: 0 -> -10 - certain';'Typical bird species: 0 -> -10 - uncertain';'Typical bird species: 0 -> +5 - certain';'Typical bird species: 0 -> +5 - uncertain';'Non-typical bird species:0 -> -10'; 'Non-typical bird species: 0 -> +5'; 'Waiting time reduced: 15 -> 7'; 'Waiting time reduced: 15 -> 3'; 'Number of rest-stop benches: doubled'; 'Number of rest-stop benches: tripled'; '- Cost (10 EUR)'};

% separately - part 1:
% DATA.Xa = [DATA.ASC,(DATA.TYPs==-1).*(DATA.TREAT==0),(DATA.TYPs==-1).*(DATA.TREAT==1),(DATA.TYPs==0.5), DATA.NTYPs==-1, DATA.NTYPs==0.5,  DATA.WT7, DATA.WT3, DATA.RP2, DATA.RP3, -DATA.PRICEs];
% EstimOpt.NamesA = {'Status quo - alternative specific constant';'Typical bird species: 0 -> -10 - certain';'Typical bird species: 0 -> -10 - uncertain';'Typical bird species: 0 -> +5';'Non-typical bird species:0 -> -10'; 'Non-typical bird species: 0 -> +5'; 'Waiting time reduced: 15 -> 7'; 'Waiting time reduced: 15 -> 3'; 'Number of rest-stop benches: doubled'; 'Number of rest-stop benches: tripled'; '- Cost (10 EUR)'};

% separately - part 2:
% DATA.Xa = [DATA.ASC,(DATA.TYPs==-1),(DATA.TYPs==0.5).*(DATA.TREAT==0),(DATA.TYPs==0.5).*(DATA.TREAT==1), DATA.NTYPs==-1, DATA.NTYPs==0.5,  DATA.WT7, DATA.WT3, DATA.RP2, DATA.RP3, -DATA.PRICEs];
% EstimOpt.NamesA = {'Status quo - alternative specific constant';'Typical bird species: 0 -> -10';'Typical bird species: 0 -> +5 - certain';'Typical bird species: 0 -> +5 - uncertain';'Non-typical bird species:0 -> -10'; 'Non-typical bird species: 0 -> +5'; 'Waiting time reduced: 15 -> 7'; 'Waiting time reduced: 15 -> 3'; 'Number of rest-stop benches: doubled'; 'Number of rest-stop benches: tripled'; '- Cost (10 EUR)'};

% separately - V2:
DATA.Xa = [DATA.ASC,(DATA.TYPs==-1).*(DATA.TREAT==0),(DATA.TYPs==-1).*(DATA.TREAT==1),(DATA.TYPs==0).*(DATA.TREAT==1),(DATA.TYPs==0.5).*(DATA.TREAT==0),(DATA.TYPs==0.5).*(DATA.TREAT==1), DATA.NTYPs==-1, DATA.NTYPs==0.5,  DATA.WT7, DATA.WT3, DATA.RP2, DATA.RP3, -DATA.PRICEs];
EstimOpt.NamesA = {'Status quo - alternative specific constant';'Typical bird species: 0 -> -10 - certain';'Typical bird species: 0 -> -10 - uncertain';'Typical bird species: 0 - uncertain';'Typical bird species: 0 -> +5 - certain';'Typical bird species: 0 -> +5 - uncertain';'Non-typical bird species:0 -> -10'; 'Non-typical bird species: 0 -> +5'; 'Waiting time reduced: 15 -> 7'; 'Waiting time reduced: 15 -> 3'; 'Number of rest-stop benches: doubled'; 'Number of rest-stop benches: tripled'; '- Cost (10 EUR)'};

% separately - V3: 
DATA.Xa = [DATA.ASC,(DATA.TYPs==0).*(DATA.TREAT==0),(-(DATA.TYPs==-1) + (DATA.TYPs==0)).*(DATA.TREAT==1),(DATA.TYPs==0.5).*(DATA.TREAT==0),(-(DATA.TYPs==-1) + (DATA.TYPs==0.5)).*(DATA.TREAT==1), DATA.NTYPs==0, DATA.NTYPs==0.5,  DATA.WT7, DATA.WT3, DATA.RP2, DATA.RP3, -DATA.PRICEs];
% (DATA.TYPs==-1).*(DATA.TREAT==1),
% 'Specialist bird species: -10 (uncertain)';
EstimOpt.NamesA = {'Status quo - alternative specific constant';'Specialist bird species: -10 -> 0 (certain)';'Specialist bird species: -10 -> 0 (uncertain)';'Specialist bird species: -10 -> +5 (certain)';'Specialist bird species: -10 -> +5 (uncertain)';'Generalist migratory bird species: -10 -> 0'; 'Generalist migratory bird species: -10 -> +5'; 'Waiting time reduced: 15 -> 7'; 'Waiting time reduced: 15 -> 3'; 'Number of rest-stop benches: doubled'; 'Number of rest-stop benches: tripled'; '- Cost (10 EUR)'};

% SD baseline:
% DATA.Xa = [DATA.ASC,(DATA.TYPs==-1),(DATA.TYPs==-1).*(DATA.TREAT==1),(DATA.TYPs==0.5),(DATA.TYPs==0.5).*(DATA.TREAT==1), DATA.NTYPs==-1, DATA.NTYPs==0.5,  DATA.WT7, DATA.WT3, DATA.RP2, DATA.RP3, -DATA.PRICEs];
% EstimOpt.NamesA = {'Status quo - alternative specific constant';'Typical bird species: 0 -> -10';'Typical bird species: 0 -> -10 - uncertain';'Typical bird species: 0 -> +5';'Typical bird species: 0 -> +5 - uncertain';'Non-typical bird species:0 -> -10'; 'Non-typical bird species: 0 -> +5'; 'Waiting time reduced: 15 -> 7'; 'Waiting time reduced: 15 -> 3'; 'Number of rest-stop benches: doubled'; 'Number of rest-stop benches: tripled'; '- Cost (10 EUR)'};

% Xm:
DATA.Xm = [DATA.GENDER, DATA.AGE, DATA.AGE.^2, DATA.CHILD_yes, DATA.CHILDREN, DATA.HOUSEH, DATA.INC, DATA.INC.^2, DATA.EDUC, DATA.EMPLOYEE, DATA.SELF_EMPL];
EstimOpt.NamesM = {'male','age','age^2','children > 0','no. of children','household size','income','income^2','tertiary education','employee','self employed'};
% DATA.Xm = [DATA.AGE, DATA.INC];  
% EstimOpt.NamesM = {'age','income'};
DATA.Xm = DATA.Xm - mean(DATA.Xm);
DATA.Xm = DATA.Xm ./ std(DATA.Xm);

DATA.Xs = DATA.TREAT;
EstimOpt.NamesS = {'Uncertain treatment'};


%% ****************************  specifying input ****************************


INPUT.Y = DATA.Y;
INPUT.Xa = DATA.Xa;
INPUT.Xs = DATA.Xs;
% INPUT.Xm = DATA.Xm;


%% ****************************  sample characteristics ****************************

EstimOpt.NCT = 6;
EstimOpt.NAlt = 3;
EstimOpt.NP = length(INPUT.Y)/EstimOpt.NCT/EstimOpt.NAlt;


%% **************************** estimation and optimization options ****************************

% EstimOpt.ProjectName = 'P_jointly';
% EstimOpt.ProjectName = 'P_separately';
% EstimOpt.ProjectName = 'P_separately-part1';
% EstimOpt.ProjectName = 'P_separately-part2';
EstimOpt.ProjectName = 'P_separately_V2';
EstimOpt.ProjectName = 'P_separately_V3';
% EstimOpt.ProjectName = 'P_SD_baseline';
% EstimOpt.ProjectName = 'P_SD_Xm';
% EstimOpt.ProjectName = 'P_SD_Xm2';

[INPUT, Results, EstimOpt, OptimOpt] = DataCleanDCE(INPUT,EstimOpt);

EstimOpt.NRep = 1e4; % number of draws for numerical simulation
% OptimOpt.MaxIter = 1; % maximum number of iterations

% OptimOpt.Algorithm = 'trust-region'; %'quasi-newton'
% EstimOpt.NumGrad = 1; % 1
% OptimOpt.GradObj = 'off'; % 'off'
% OptimOpt.FinDiffType = 'central'; % 'forward'
% OptimOpt.Hessian = 'user-supplied'; % 'off'
% EstimOpt.HessEstFix = 1 ; % 0 = use optimization Hessian, 1 = use jacobian-based (BHHH) Hessian, 2 - use high-precision jacobian-based (BHHH) Hessian 3 - use numerical Hessian

try


%% ****************************     MNL     ****************************


% B_backup = [-3.53587330046595;-4.04288075809546;-1.30951909847629;-2.48395743615349;0.777665108115451;-4.95346051921771;-0.350432721301655;1.51211653903442;4.09317189477120;0.158416675038213;-2.75912317778047;0.247655165877167;-0.788535863764076];

Results.MNL = MNL(INPUT,Results,EstimOpt,OptimOpt);


%% ****************************     MXL_d     ****************************

EstimOpt.FullCov = 0;

EstimOpt.Dist = [zeros(size(INPUT.Xa,2)-1,1);1];

% jointly: -2155.1360
% B_backup = [-3.67534722639863;-3.70309538118606;0.996724528004493;-2.44059316200797;0.283779273671150;0.684587134588671;0.359639853668882;0.815971729523225;-0.0983349332079169;1.77897684205426;3.66666472717187;2.41015468729386;0.294564568374642;1.54374401663002;-0.751245317172440;0.504750587634897;-0.719076209682359;0.727302200125917;1.78057985710693;0.809496141982020;-0.474618946866809];

% separately: -2146.4135
% B_backup = [-3.65275229390776;-3.15263696546384;-3.82523325841462;0.644032531751221;1.49499664373180;-2.45298190965340;0.240429368134753;0.616747003676181;0.376191602540991;0.685180991668267;-0.298963613693034;1.76006877711501;3.45597033866017;1.45728548074674;3.05262480700959;-0.0628243915576063;1.86712623934029;1.46788740231593;-0.292859412543236;0.303145881074347;-0.783492681025649;0.666423741910089;1.84084740928962;0.803794717245282;-0.439827425950669];

% separately - part 1: -2148.7962
% B_backup = [-3.67184887128773;-3.17935072339052;-4.15202147117998;0.990962634886962;-2.53303246608208;0.272573072525353;0.653687232072212;0.376716221962828;0.771291920971928;-0.156367706603984;1.78700572964415;3.48567568168689;1.51791943763771;3.20788591112746;0.0182153849594077;1.52562676214398;-0.540310113076714;-0.342025684583305;0.760583038992845;0.552238227843114;1.84483706573911;0.808145202327405;-0.533848033560545];

% separately - part 2: -2150.7931
% B_backup = [-3.73105903826451;-3.52683836220172;0.618401171899403;1.54986030966480;-2.39661494979330;0.245719800355422;0.630142173667808;0.391335277867428;0.709636989692820;-0.287112278283671;1.76501917559559;3.52189558746027;2.28049969551895;0.103208389946890;1.73150936745893;1.51164449148844;-0.394926502691808;-0.293579315000287;-0.785065205914255;0.705962063513255;1.75908738904670;0.818776985201381;-0.434171224167165];

% separately V2: -2145.9580
% B_backup = [-3.70025026795433;-3.26448601984702;-2.64457817639573;1.23055401223206;0.645262962184281;2.72681925759685;-2.48716258702121;0.245394689933930;0.629482708326021;0.380376901554104;0.694368427647155;-0.286894068856584;1.77049382290355;3.43113143931533;1.58604304859058;3.13806463050270;0.311746262900192;-0.0259702724626733;1.64309821520618;1.54524406687862;0.408466710746035;0.386182107065980;0.800642423030577;0.683944120097739;1.82131737092682;0.808510872955801;-0.460007637100231];

% SD (baseline model with deviations from no difference): -2146.0483
% B_backup = [-3.64494684698499;-3.18140518319550;-0.551098071321095;0.637398227787759;0.865790579838712;-2.42548544828039;0.234675152626067;0.622591168478802;0.374198751851897;0.670502853841228;-0.322047981497275;1.75532501392844;3.58761526735591;1.57163776519282;2.68027804265789;-0.161274662405618;1.94945739039332;1.47642247435419;0.186176860923514;-0.175090827918540;0.754518567374887;0.517628446723559;1.82470131766987;0.796342482735668;-0.426417487649846];

% SD: -2048.5629
% B_backup = [B_backup; zeros(size(INPUT.Xm,2).*size(INPUT.Xa,2),1)];
% B_backup = [-4.24465655100224;-3.59834474147998;-0.601727842129879;0.663891406628346;1.11146618978622;-2.72522438791855;0.274788173563936;0.721947088473251;0.482648727946776;0.754751081400242;-0.342140291031193;1.88986074123841;3.63145429985294;1.80628045207020;2.64793987364017;-0.190147375578521;1.48857277639556;1.44266597336062;0.136871497861244;-0.341027443781803;0.328101739263898;-0.358675077256974;1.98148058866957;0.759164822098457;0.279213886608289;-0.308333994401939;0.128279600607451;0.0602372976163164;-0.0529254467208923;0.594803051185211;0.312487644070975;-0.0156440077386721;0.000423479699084194;-0.0299083797301079;0.232512322919126;-0.0259589296115622;1.11939576677810;-0.0482457461868104;-5.36166054617978;-1.27108558543115;2.07680939345354;-2.70776280599750;-2.35215258639787;0.418610410034782;3.04595258765684;-1.85714335483637;-0.805277923616809;0.0352014426227301;-1.21986426089695;0.0618780759805895;5.35246217752504;0.752185986179740;-2.64565401278225;3.37331962717518;1.75291666480161;-0.846867028485528;-3.53296769233230;2.56056078443082;1.04889372242580;-0.0825983921788562;-0.849483867758801;-0.474695996617083;-0.339208794281608;-0.0517323773459122;-0.740392569318974;-0.119418516868811;0.130683504843013;-0.549198779575040;-0.688544328732875;0.485393650287973;0.360044750104338;0.211565305167546;1.32268124307535;0.0231251969039799;0.452629973564713;0.281248820625625;0.460364842037084;-0.0179978477493757;-0.100805205940498;0.0867385244899712;0.523650891306481;0.411638555997195;0.452954423084442;-0.127995515661943;-1.10688075186789;0.411540174661020;0.0211160673093236;-0.258427067347955;0.263605206672783;0.344529148135628;0.0625793336560181;0.0822505281371562;-0.163886801590537;-0.470911214035037;-0.498058314083359;0.143570867921036;2.38348784379596;-0.860318140861527;1.95948024762125;0.223594712065998;-0.272614648871759;-1.03641091549306;1.24541868570494;1.01228574944230;0.554038265951893;0.0581926821453767;0.690738759702742;-0.394187937475640;-1.95369426178265;0.751989424759280;-2.63603657669275;-0.487470027552330;0.0104590883771919;0.732362833555714;-1.14511908859731;-1.16443217737657;-0.665581587894945;-0.00930217280615541;-0.922008866499004;0.210118292341290;0.835884695713595;0.426624082282223;-1.00562990029914;0.0725842138487296;-0.263139818480642;0.0616754823016683;0.147355093269009;-0.155914805806986;0.0704324568110923;0.00365849801009586;-0.237438603777348;-0.104546294211354;-0.513242744442248;-0.398987939010014;0.233359827153691;0.147659193930481;-0.303946342198036;0.510989841251108;-0.486136188404011;-0.171306264773308;-0.0414327241603495;0.422725764607938;-0.103063054698549;0.0264395582560640;0.0588366082515789;-0.639022858825668;0.826401648804542;-0.465384180064239;0.487233466049979;0.0983709751420322;-0.153521625879770;0.103170306719427;0.561764116373196;0.332917550966693;0.0843361770219432;0.0219979044933768;-0.568224615228707];

% SD2: -2132.7420
% BAtmp = zeros(size(INPUT.Xa,2),size(INPUT.Xm,2));
% BAtmp([3,5],:) = 1;
% EstimOpt.BActive = [ones(size(INPUT.Xa,2)*2,1);BAtmp(:);1];
% B_backup = B_backup .* EstimOpt.BActive;
% B_backup = [-3.62908888872334;-3.22744261037646;-0.529959896047220;0.645850926871483;0.862191086899471;-2.45694979133502;0.252169938635471;0.646705154207464;0.395344367890997;0.670795634301184;-0.317931578594504;1.76321729154044;3.65161102340475;1.59520994990326;2.38389112971024;-0.266554167982825;1.73313004502369;1.58709301126530;0.299489257930511;-0.224982516994338;0.772173712518922;0.533587377420371;1.83867854737725;0.788900755938314;0;0;-0.327099316605211;0;0.168110889016326;0;0;0;0;0;0;0;0;0;-3.70231300848248;0;0.349368711546322;0;0;0;0;0;0;0;0;0;3.70461273949761;0;-0.938844945596916;0;0;0;0;0;0;0;0;0;-0.293053852772472;0;-0.702636144103134;0;0;0;0;0;0;0;0;0;0.298764346482683;0;0.839814804101036;0;0;0;0;0;0;0;0;0;0.343201171187614;0;-0.143993700759260;0;0;0;0;0;0;0;0;0;0.805724672778362;0;-0.170221551836802;0;0;0;0;0;0;0;0;0;-1.68872779958054;0;-0.330401872957455;0;0;0;0;0;0;0;0;0;-0.588502892847052;0;-0.187380456520315;0;0;0;0;0;0;0;0;0;-0.207047779479628;0;0.0301322760596508;0;0;0;0;0;0;0;0;0;0.217622243871976;0;-0.0154741159764405;0;0;0;0;0;0;0;-0.430407928989184];

OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
OptimOpt.Hessian = 'user-supplied'; % 'off'

Results.MXL_d = MXL(INPUT,Results,EstimOpt,OptimOpt);

% EstimOpt.HessEstFix = 1;

OptimOpt.Algorithm = 'quasi-newton';
OptimOpt.Hessian = 'off';

Results.MXL_d = MXL(INPUT,Results,EstimOpt,OptimOpt);


%% ****************************     MXL     ****************************


EstimOpt.FullCov = 1;

% jointly: -2047.3069
% B_backup =  [-6.57585464975902;-5.05469914742711;1.55569471360561;-3.74446381432417;0.800730682022948;1.33922219862804;0.617168738442562;0.656772416237420;-0.877502882370692;2.16965527846303;7.98296769806827;-1.73569850610291;-0.480953121093474;-1.37900422777245;-0.437388848549083;-0.0720035476553146;-0.0390922598261599;0.394151644112790;0.361770569021697;-0.790345957146928;3.51316741559496;-0.642085977511526;0.877701547612967;-1.12227499137578;-0.192083189460482;0.254012662523145;-0.615016550912163;0.903218055313167;-0.515873492668341;-1.01424532702416;0.366571905643084;0.943642332499111;0.461992360113366;0.198018723929713;-0.820793536546929;0.0214477914026220;0.131673948876014;2.77295428081227;0.687596374982138;-1.04364000575716;-1.40903366410750;0.753118056781413;0.294017919388850;-0.548440493906834;-1.17732251761228;1.41578245194864;1.53246907869338;0.144359346465320;0.977648258616061;-0.201777609367489;1.07016409531897;0.297394491396356;0.146405720297322;-0.782897800127992;-0.0499864264216033;0.432486755104913;-0.501760162823822;1.22949581316272;-0.0174282458690249;0.287292185529482;0.0347155908287023;-0.146507784825289;0.280233807805858;0.0956862462529577;0.439438283204707;-0.343368472959192];

% separately: -2019.7910
% B_backup = [-7.84819867375642;-6.47792119744818;-6.93142377452450;0.662409429643387;3.48663934581902;-5.06928852065141;1.10878526610698;2.04312757658463;1.30515188711676;0.215996179925897;-2.20900164775060;2.44177881595212;10.3370829054700;-1.11263424132534;-4.91884611871105;-0.0484928948913023;-0.662863398204930;-1.86822349545619;-0.939351985184494;0.354960221074209;0.369686079463488;0.596823311263870;0.505415413536359;-0.747114752596079;4.04834698376627;1.75092784418655;0.600692837493581;-1.13618850527802;1.78107505865987;-0.842085580606984;-0.982138384537944;-0.955531376437856;-0.0879957740223675;2.30565375724342;-0.594625656489845;4.03259581428589;0.334923230443383;-1.46701193835583;0.693662372554295;-1.66441131916796;0.741873724403442;1.03604848003952;0.337077003286107;1.02391827828434;-0.364172664367153;-1.67087090766293;-0.0543032197170591;3.07722741998497;1.75492095541694;-0.395969630887251;-0.608428149575619;0.135468383561910;0.143575223046654;-0.300732136358814;3.38433520548044;0.450022808699171;-0.590697877633593;1.01909512658630;0.540971902954308;1.28660220335790;-0.807269247077625;-0.113498141524085;2.05881034423445;0.885135550396884;-1.54809904549822;-2.37384930062146;1.16302010715658;-1.41824343215490;-0.266772763844590;-1.05733925168443;0.304118483263466;0.387883478446812;-0.157882834211766;-0.350027003502705;0.0711572395458434;-2.26391427712421;-1.36565501820611;0.529702726012957;-0.719301855934059;-0.156463878553178;1.57009108848893;0.0853005666900273;1.30519660379741;0.113213944926782;-0.305036244501793;-0.720975981745119;0.0737014893889975;-0.242344799131407;-0.188591955654150;0.330042122617610;0.148435253366155];

% separately - part 1: -2031.2799
% B_backup = [-8.62030873339357;-6.04636235752031;-8.15889835384885;1.97048074573432;-5.08119754202360;0.883300685925773;1.71419894244953;0.916953555544725;0.668809343831464;-1.60863693681472;2.49569194055255;10.5429383531822;-1.80238083819411;-4.95056014862058;-0.430593328424940;-2.06182628904078;-0.493707189912019;0.233344313012356;0.393941469007503;0.399461075432650;0.605162959367427;-0.762801279101075;4.09486568581887;4.40144704966397;-0.548541021910880;1.19962298538195;-1.35860996678443;-0.311880642096056;0.212457711507625;-0.739680099810699;1.54307780915477;-0.629115162288111;2.60292119852875;-0.493532922178564;0.480857054486293;-0.939210963024535;0.418322818579384;0.240078948120191;-0.278858114478199;-0.000126391709671808;-0.161372455824185;-1.62894187914011;2.23628589760705;2.27961506366841;-1.66138456749341;-1.88807740156527;-0.308578576400002;-0.133839941664906;-0.0677295430528241;3.33714338556614;0.244674239766307;-0.186949490565967;-0.893373435215732;1.38810845655786;0.563197699182218;-0.480906052318846;0.671154638121301;0.928448106254086;-0.0417361588692452;0.117957240170825;-0.922521024694418;-0.258812643915366;2.32842064230712;2.38529197132730;-0.501684415455273;1.25478198157343;0.214076434438940;0.885796533984211;0.381808212659348;1.70759315009340;-0.0739169720250024;0.688007178275044;-1.46132880477292;-0.00678374987922290;-0.0288991771494129;0.0878100249978201;0.213554358250825;-0.677753526490515];

% separately - part 2: -2035.8827
% B_backup = [-7.87550543497261;-5.75410609416559;0.110165341293972;3.20401426024198;-4.21929058756471;0.795048576386433;1.56340218603369;0.850002214684924;0.158978872553103;-1.96146385746817;2.29571799508192;9.35582053013603;-1.84204282559821;-0.151244972601810;-1.20058877288497;-1.38282069457921;-0.708548179033955;0.226304630627829;0.329261845256872;0.805654706936816;0.815956665618017;-0.831571950826120;4.13765895385700;0.551868778865523;-1.81867869581325;0.992907208496693;-1.18889094418496;0.174399128085749;0.475957203441669;-0.245695913150232;1.58025086559377;-0.503556381363541;1.11196733512449;0.216459974300063;-0.580702765800679;-1.86765068521230;0.906883678811277;1.25487568000573;0.369403976939431;1.03429732989435;-0.160108009524223;1.48579600278546;1.11442231585280;0.383565716653164;0.938717082454354;0.251487326614025;1.23971244887877;-0.852050911285296;-0.243998128628969;2.99233049166780;0.914243853801057;-1.95502648890841;-2.09447459334405;0.457517785967929;0.392857464935526;-0.501683501936924;0.292514439277031;-1.15336623861200;-1.50482645842301;0.430861902856297;-1.79482479885342;-0.0939908148687776;1.33370661747428;0.297256257476232;-0.582791789149410;-0.728784612241343;0.0660407462619355;0.102743291716312;0.264480097845846;0.0972759507182190;-0.156675814529891;0.00793571467504619;-0.614725123469392;0.0554144993612474;-0.389020243997748;0.181975976654855;0.366418234049715;-0.460862118733015];

% separately V2: -2018.6869
% B_backup = [-10.6781128210493;-8.26700879044413;-7.68323778339276;1.56480304600854;0.445904677518533;5.69333785381944;-6.21752615738513;1.32684309179359;2.53269896867599;1.67503629691489;0.0438928997665674;-2.67603909867384;2.75220398983247;13.1984070004997;-1.53935940817555;-3.52067119444098;2.17856829695542;0.235005365010502;1.31430266734583;-2.68189144007491;-1.40819089596447;0.735054971122060;0.961374985407539;1.04706500938408;0.833117448306026;-0.710026960152186;5.52920292764112;1.06101230392430;-2.32108089871624;0.415752515095770;-3.72765840593571;2.01169975508491;-1.10654585265669;0.270626228088196;-0.518617125480068;-0.0368294508758140;2.20897805541849;-0.595456825789941;7.22954533191656;2.62001354275879;1.22535224923197;1.63182995607891;-0.476786871581919;-2.47923875324102;0.491133814547722;1.41973548223365;1.04911927371512;0.608206960498745;-0.292681706716213;-0.348647223038253;1.34911193921133;-2.07894891895946;-3.21656894524322;-1.77106726780692;1.37452650479330;0.752327310455088;-0.374110508326442;0.261767543210638;0.482516548807854;0.129443172072472;-3.35085779473357;-0.880665843481538;-0.509498529085668;-1.10861114746487;0.879495666154697;-1.73313914310695;3.12844645413276;0.148866100041392;-2.27750460988490;1.21358035884426;1.71949807075445;-2.44517378455459;-2.32858005390481;0.655482242634293;0.341433886436597;-0.115639723056275;2.81179963945288;-0.783650685905362;-0.820767052072604;-1.83973464753493;0.418771411733233;0.000684515409346304;-0.172392690586085;0.574403594832800;-1.84617383539445;-2.73937332171502;-0.211315243941979;-2.06999832113720;-0.189878711195894;-2.60957783523939;-1.67913968001496;1.05199008337370;-0.914890493015697;-0.00952016736817363;0.837976545026294;0.764153596646225;0.275550906112492;0.193261677787908;0.662343753893703;0.962607173693046;-0.133781585346702;0.696477677338630;-0.0434287817517196;0.113916930384089;-0.344739356972673];

% SD (baseline model with deviations from no difference): -2019.2407
% B_backup = [-21.6233893455943;-15.7519752090378;-2.65533162471712;2.04837993838216;7.35272255205949;-12.6712839949240;2.73379431659124;4.81558876506260;3.09994946861670;0.919395829037314;-5.49658164405855;3.40995471116035;25.9377017669744;-2.22465395102088;-9.00742953500757;0.295465440935466;-3.44620675077672;-4.79017410185625;-2.22806395620827;-0.0196190444903218;0.755713401239570;1.25714588627503;2.24419734696561;-0.783890392852370;10.5437406246988;-2.32432831938462;0.979607395396756;-1.79312902276602;3.03174491256049;-4.05363085690143;0.0460881929943701;0.488397617133635;-0.335153917871504;5.40956396954235;-0.488907138026323;10.0751958613596;0.267050618421576;-4.96548786800371;0.300737196409374;-4.05806655137178;1.84501936603716;1.29946657800813;0.127715887780740;-0.365785208735757;-0.286279979934917;-4.38928678290987;1.31231680696686;6.47523996850791;4.59909829641772;0.538540127506749;-1.64859938689839;-1.21912129981473;0.268748148656451;-0.311435621500592;-6.62814602881285;-1.77809761942278;0.441616052781676;-2.98447209446501;-0.582489337363166;-3.86124340323579;2.84529403871610;0.144462630267640;7.46153573523143;1.34928719153871;-5.78816197735483;-4.92387813055469;2.33023769325342;0.482046184424098;-0.366539929506859;-2.38921580156624;3.77504572139888;6.49968095577971;-2.03942337024764;4.16760406679828;0.181055002270330;0.208085961997269;-1.11053083198642;-1.63733154105840;-3.99403115356269;-0.0733763495622508;-0.878399348161013;0.291489908497229;-1.49325866733543;0.241455395213552;0.536806944815481;0.861330749904741;-0.229587392081067;-0.131601360186763;0.238093850660348;0.192223172293412;-1.40798376173509];

% SD: -1925.9583
% B_backup = [B_backup; zeros(size(INPUT.Xm,2).*size(INPUT.Xa,2),1)];
% B_backup = [-54.8147589369582;-35.7419372719035;-7.15372501461574;4.61875548870625;17.5937289408457;-29.1746986157451;4.49944021888421;10.1850359794502;5.80166209970369;2.63960124838779;-12.0888313112451;4.29562571326549;55.5188669041346;-6.56984393841805;-15.4313552213731;-0.970118275358296;-5.19357172322982;-8.90454014638940;-3.31130825722788;-0.863715688632904;0.0374429461986410;-0.378129878626121;2.70233234804280;-0.781426421853067;25.5303044471361;-11.8242800460692;4.09545936127346;-10.5667941484338;6.54876555990326;-4.86487813308070;-0.246714642789221;2.35198875849940;-1.02820568188104;9.45359622109196;-0.450427500067151;25.5734311180011;2.09916426000068;-9.74719398113698;1.91298462128616;-8.82606456418240;3.68372089973275;5.78564420809601;0.0710588270820200;5.29185370600740;-0.312281111639446;-9.59091854047259;4.27195587846512;9.74094057758250;10.2155273521284;-0.0963338952519468;-1.98994756891278;-1.06374553243388;-0.0823208406554832;-0.176436019154681;-16.9864701014185;-6.32242321560392;-0.169741823571458;-6.02254059648661;-1.42463380552631;-7.39138690026636;6.59935137118703;0.227984733161718;15.2807462623094;2.59639977701111;-9.31326769716504;-9.49124263114824;2.12686440493453;0.843897218875411;-0.350554023063334;-2.39814005308823;10.7901590370772;12.1215863621309;-4.24495611359060;6.99077898007868;0.175642401515901;3.07401895933340;1.35910434271714;-1.87700868317921;-9.82224442806721;0.0462698985493744;-0.556824767095830;0.561271439017626;0.852879268355639;0.259020887451975;1.23377935614993;5.29602403072202;-0.201865985267850;-1.10005436465155;0.140958146881336;0.117007392171754;3.02846983937578;-3.41211633695335;3.80737993832041;-0.141866404698896;-0.353179989338067;6.00336347246021;2.73471582431417;0.0299519669938207;0.0194440779615590;0.826239430170056;2.85361756422569;-0.0219768878446041;1.86646052274107;-13.3407706613538;-22.7977252031350;-4.93423462004621;9.21127874504466;-20.2912256328115;-19.4565252541520;2.63257090979000;20.4410882859207;-7.58233778559279;6.07692071050572;-0.0270615404212624;-6.36857209520157;16.4354300926743;16.8193937001895;0.0266324034749015;-14.8632134037048;25.8947064262871;14.7888183457714;-5.85560275976951;-24.3676921928495;14.3661122548587;-3.35612578502931;0.0687675590075043;-14.2874013738540;-4.14825801491072;1.31375564836169;-3.44098002079194;-5.53156563854167;4.02027715553269;4.23769017017420;-6.99794197869624;-7.91323524220389;3.54684908100814;4.02421929212201;0.244468365370734;20.7654737219743;-1.40686806123968;2.20682265249224;2.82025801121110;3.88776981002131;-4.18492892854607;-4.03212190100164;2.75377517193080;6.60797512576451;4.35985539506291;1.92914063997210;-0.217654591000079;-14.0934543036663;4.25275092931950;-2.81484884005897;-2.05231477835375;2.50952929177811;2.69817655866133;0.760984610626372;1.23209596686776;-2.53040682585311;-5.81297589036271;-5.21747708675608;0.195449541385148;33.7745075259373;-2.48373409264406;3.54130579297513;1.72979680541917;-1.68086635824791;-0.880725311037259;12.3113679891630;10.0851317755092;5.65064158587918;-2.42293454362788;7.07578570518319;-0.524314983197155;-24.5730578048332;1.36033420782115;-9.04433243478965;-4.07348473147161;-0.540636040264791;-1.72957837304965;-11.6465086246317;-11.4180050649661;-5.96847292467916;3.88470165762117;-8.54682603553247;0.314741984108852;4.02423944799096;3.93867741080455;-9.96646072456780;1.13987077887306;-2.88180283194364;0.356502445891006;3.29476541223994;-0.805097756059113;0.589176800033570;-0.107470106014355;-1.33342323452622;-0.0377283088494302;-5.50736345925522;-0.0302453783156996;-2.47719784239594;0.950121116378316;-1.64131340595875;4.83569166468919;-4.92789168735129;-1.61215597033481;0.193078706297877;4.33713946888955;-1.70204281701747;0.0601979138677521;-0.0141471814515821;-1.12859040546071;0.736860915779885;-0.908490874357440;1.98837962740638;0.243476745542973;-1.85840833264470;1.07253550114029;5.16915008053194;3.32683550918417;-0.0936056836790656;0.0502982784916638;-2.47172594387871];

% SD2: -2005.9296
% BAtmp = zeros(size(INPUT.Xa,2),size(INPUT.Xm,2));
% BAtmp([3,5],:) = 1;
% EstimOpt.BActive = [ones(size(INPUT.Xa,2)+sum(1:size(INPUT.Xa,2)),1);BAtmp(:);1];
% B_backup = B_backup .* EstimOpt.BActive;
% B_backup = [-43.4100899690067;-30.6986583993642;-5.01881243176794;4.01001431687899;14.5915134889460;-24.7676395946482;5.31587780980494;10.2336339895315;6.12564598025814;1.71271159715799;-10.9026672017483;4.10103989609074;52.0404634391297;-4.76425591873510;-16.2618100941011;1.37080717436149;-7.35713608195487;-9.74471336057767;-4.02830525264443;-0.960628235250435;1.47372267852893;2.34200643514232;4.15486764025924;-0.786947668681099;20.2987523032274;-6.02466237244351;4.22034170896031;-10.3939483464510;5.27638909114834;-7.22027723633883;-3.10328659515743;-0.846661852421599;-0.478342749279666;9.85329109193002;-0.504391537941783;18.8007654163293;0.829176948244326;-5.80435944176166;0.900539591073476;-6.92070700668483;5.59658005040297;3.57246861786847;-0.00160381203586596;-1.08843344772760;-0.274299168214706;-9.42849645422181;11.3605010615502;13.8094868920063;8.36004010914026;2.27678656026091;-1.93132172520591;-1.11855895482640;0.0230469190799209;-0.338841211941717;-13.2719574818874;-2.72342572991034;0.698281201306273;-3.81437367787156;-0.357203419348828;-6.70358622208878;7.55238078075736;0.143453233891271;14.6415022339626;2.07720551826645;-12.5550465283493;-11.2905087196653;4.19668411609472;2.34166014891240;-0.384181613701821;-7.82543825458665;6.62398997158499;12.6958915915482;-2.64809200826095;9.76089791618503;0.143146049307209;-1.95699546959847;-2.05169274384429;-2.44421143913125;-5.91321931530214;-0.0933738321856494;-2.79995568221562;-0.744723942957506;-3.88640055731679;0.210202636469943;0.708827672253555;1.17553865165244;-0.246925657548434;-1.26972559310124;0.189855900754651;0.195961963932782;0;0;1.16486243275555;0;0.869545940835814;0;0;0;0;0;0;0;0;0;-18.8051490920863;0;8.40217261034970;0;0;0;0;0;0;0;0;0;15.9486087101199;0;-15.2139776329121;0;0;0;0;0;0;0;0;0;0.713244153089144;0;-1.88764775139287;0;0;0;0;0;0;0;0;0;0.00242823121852520;0;0.825343863514172;0;0;0;0;0;0;0;0;0;0.584677250528397;0;-1.20261958592068;0;0;0;0;0;0;0;0;0;-0.856046778627608;0;-0.557848385630638;0;0;0;0;0;0;0;0;0;-4.32651581132725;0;-3.95355378607578;0;0;0;0;0;0;0;0;0;-3.83356085460697;0;-1.77913943490900;0;0;0;0;0;0;0;0;0;-3.18905639261776;0;-1.01831521466853;0;0;0;0;0;0;0;0;0;-0.103507232275452;0;-0.613587334745026;0;0;0;0;0;0;0;-2.22395984209577];


OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
OptimOpt.Hessian = 'user-supplied'; % 'off'

Results.MXL = MXL(INPUT,Results,EstimOpt,OptimOpt);

% EstimOpt.HessEstFix = 1;

OptimOpt.Algorithm = 'quasi-newton';
OptimOpt.Hessian = 'off';

Results.MXL = MXL(INPUT,Results,EstimOpt,OptimOpt);


sendmail('mik@czaj.org','MATLAB: D1 - done!');
       
catch theErrorInfo
   
    sendmail('mik@czaj.org','MATLAB: D1 - error!',theErrorInfo.message);
    rethrow(theErrorInfo)
    
end




