% Mallorca risk study 2016-12-07

clear
clc

global B_backup;

%% ****************************  loading data  ****************************


EstimOpt.fnameinput = ('data_mallorca_01.mat'); 
DATA = load(EstimOpt.fnameinput);


%% ****************************  data transformations  ****************************

DATA.INC = NaN(size(DATA.INCOME));
DATA.INC(DATA.INCOME == 1) = 500;
DATA.INC(DATA.INCOME == 2) = 1500;
DATA.INC(DATA.INCOME == 3) = 2500;
DATA.INC(DATA.INCOME == 4) = 3500;
DATA.INC(DATA.INCOME == 5) = 4500;
DATA.INC(DATA.INCOME == 6) = 5500;
DATA.INC(DATA.INCOME == 7) = 6500;
DATA.INC(DATA.INCOME == 8) = 7500;


%% ****************************  model specification  ****************************


DATA.Y = DATA.CHOICE;

% separately:
DATA.Xa = [DATA.ASC,(DATA.TYPs==-1).*(DATA.TREAT==0),(DATA.TYPs==-1).*(DATA.TREAT==1),(DATA.TYPs==0.5).*(DATA.TREAT==0),(DATA.TYPs==0.5).*(DATA.TREAT==1), DATA.NTYPs==-1, DATA.NTYPs==0.5,  DATA.WT7, DATA.WT3, DATA.RP2, DATA.RP3, -DATA.PRICEs];
EstimOpt.NamesA = {'Status quo - alternative specific constant';'Typical bird species: 0 -> -10 - certain';'Typical bird species: 0 -> -10 - uncertain';'Typical bird species: 0 -> +5 - certain';'Typical bird species: 0 -> +5 - uncertain';'Non-typical bird species:0 -> -10'; 'Non-typical bird species: 0 -> +5'; 'Waiting time reduced: 15 -> 7'; 'Waiting time reduced: 15 -> 3'; 'Number of rest-stop benches: doubled'; 'Number of rest-stop benches: tripled'; '- Cost (10 EUR)'};
 
% DATA.Xs = DATA.TREAT;
% EstimOpt.NamesS = {'Uncertain treatment'};


%% ****************************  specifying input ****************************


INPUT.Y = DATA.Y;
INPUT.Xa = DATA.Xa;
% INPUT.Xs = DATA.Xs;
% INPUT.Xm = DATA.Xm;


%% ****************************  sample characteristics ****************************

EstimOpt.NCT = 6;
EstimOpt.NAlt = 3;
EstimOpt.NP = length(INPUT.Y)/EstimOpt.NCT/EstimOpt.NAlt;


%% **************************** estimation and optimization options ****************************

EstimOpt.ProjectName = 'W_separately';

[INPUT, Results, EstimOpt, OptimOpt] = DataCleanDCE(INPUT,EstimOpt);

EstimOpt.NRep = 1e3; % number of draws for numerical simulation
% OptimOpt.MaxIter = 1; % maximum number of iterations

% OptimOpt.Algorithm = 'trust-region'; %'quasi-newton'
% EstimOpt.NumGrad = 1; % 1
% OptimOpt.GradObj = 'off'; % 'off'
% OptimOpt.FinDiffType = 'central'; % 'forward'
% OptimOpt.Hessian = 'user-supplied'; % 'off'
% EstimOpt.HessEstFix = 1 ; % 0 = use optimization Hessian, 1 = use jacobian-based (BHHH) Hessian, 2 - use high-precision jacobian-based (BHHH) Hessian 3 - use numerical Hessian

EstimOpt.WTP_space = 1;

try

    
%% ****************************     LML     ****************************

% EstimOpt.Bounds = [Results.MXL_d.DetailsA(:,1),Results.MXL_d.DetailsA(:,1)];
% EstimOpt.Bounds(:,1) = EstimOpt.Bounds(:,1) - 2*Results.MXL_d.DetailsV(:,1);
% EstimOpt.Bounds(:,2) = EstimOpt.Bounds(:,2) + 2*Results.MXL_d.DetailsV(:,1);
% EstimOpt.Bounds = [-1.72881960276573,0.825853004765250;-1.20925755890402,0.0849446341341610;-2.11364618682238,0.730262246713902;-0.324269151288182,0.407301009857670;-0.555294668197028,1.25896966601574;-1.18698612065455,0.309790138635345;-0.0608817301663591,0.0698500966633841;-0.0235958533882850,0.472730563482931;-0.626439145673255,0.749606369419930;-0.356469157111424,0.431157378324436;-1.14178077214658,0.834183718256390;-1.14606424106136,9.33176599913888];

% EstimOpt.Bounds = [Results.MXL.DetailsA(:,1),Results.MXL.DetailsA(:,1)];
% EstimOpt.Bounds(:,1) = EstimOpt.Bounds(:,1) - 2*Results.MXL.DetailsV(:,1);
% EstimOpt.Bounds(:,2) = EstimOpt.Bounds(:,2) + 2*Results.MXL.DetailsV(:,1);

% EstimOpt.Bounds(end,:) = exp(EstimOpt.Bounds(end,:));
% EstimOpt.Bounds(end,1) = eps;

%  MXL_d n:
EstimOpt.Bounds = [-1.68844096046030,0.817842644818000;-1.17934593104920,0.0707087457515041;-2.23370947479872,0.785346408956231;-0.324887968984910,0.405982813638694;-0.560041163264144,1.30828311130392;-1.27945471615631,0.384737248391954;-0.0352840585026058,0.0491884740938557;0.141021860825579,0.301199001392455;-0.590957028112624,0.731555670380574;-0.388458865061238,0.506964481967398;-1.09247602998961,0.785973450210137;-0.572099720281100,17.3416776037324];

% MXL n:
% EstimOpt.Bounds = [-1.87723251506225,0.860400019140119;-1.21744802098900,0.309906086531603;-2.14345739622377,0.864429393186783;-0.658959272898268,0.827618404287995;-0.752403217287555,1.33370300041170;-1.33323738753688,0.424073615527935;-0.490818655501919,0.500156676133515;-0.419097371184680,0.789361244574904;-0.598922647605363,0.758001046475263;-0.746046708197954,0.865439190664344;-1.09086915436906,0.845338152510897;-7.20563185960214,74.6043174924946];

EstimOpt.Bounds(end,1) = eps;
 
EstimOpt.RealMin = 1;
EstimOpt.HessEstFix = 1;
OptimOpt.MaxIter = 1e3;

EstimOpt.LMLSearchNOrder = 10;
EstimOpt.LMLSearchNTrials = 10;

load('LML_W_B_1k.mat','B_out')

[Betas,Summary,DetailedResults] = LML_search(INPUT,Results,EstimOpt,OptimOpt,B_out);

% [Betas,Summary,DetailedResults] = LML_search(INPUT,Results,EstimOpt,OptimOpt,B_out,Summary,DetailedResults,SimIdx_in);


save('LML_W_B_1k_new.mat','Betas')
save('LML_W_B_1k_all_new.mat')


EstimOpt.RealMin = 0;
EstimOpt.HessEstFix = 0;
OptimOpt.MaxIter = 1e4;
EstimOpt.NGrid = 1e4;
EstimOpt.NRep = 1e4;
EstimOpt.FullCov = 0;
EstimOpt.NOrder = 8;
EstimOpt.Dist = 6; 
B_backup = Betas(8,:,5,1);
B_backup(isnan(B_backup)) = [];

Results.LML_d = LML(INPUT,Results,EstimOpt,OptimOpt);

sendmail('mik@czaj.org','MATLAB: D1 - done!');
       
catch theErrorInfo
   
    sendmail('mik@czaj.org','MATLAB: D1 - error!',theErrorInfo.message);
    rethrow(theErrorInfo)
    
end




