% Mallorca risk study 2016-12-07

clear
clc

global B_backup;

%% ****************************  loading data  ****************************


EstimOpt.fnameinput = ('data_mallorca_01.mat'); 
DATA = load(EstimOpt.fnameinput);


%% ****************************  data transformations  ****************************

DATA.INC = NaN(size(DATA.INCOME));
DATA.INC(DATA.INCOME == 1) = 500;
DATA.INC(DATA.INCOME == 2) = 1500;
DATA.INC(DATA.INCOME == 3) = 2500;
DATA.INC(DATA.INCOME == 4) = 3500;
DATA.INC(DATA.INCOME == 5) = 4500;
DATA.INC(DATA.INCOME == 6) = 5500;
DATA.INC(DATA.INCOME == 7) = 6500;
DATA.INC(DATA.INCOME == 8) = 7500;


%% ****************************  model specification  ****************************


DATA.Y = DATA.CHOICE;

% jointly:
DATA.Xa = [DATA.ASC, DATA.TYPs==-1, DATA.TYPs==0.5, DATA.NTYPs==-1, DATA.NTYPs==0.5, DATA.WT7, DATA.WT3, DATA.RP2, DATA.RP3, -DATA.PRICEs];
EstimOpt.NamesA = {'Status quo - alternative specific constant';'Typical bird species: 0 -> -10';'Typical bird species: 0 -> +5';'Non-typical bird species: 0 -> -10';'Non-typical bird species: 0 -> +5';'Waiting time reduced: 15 -> 7';'Waiting time reduced: 15 -> 3';'Number of rest-stop benches: doubled'; 'Number of rest-stop benches: tripled'; '- Cost (10 EUR)'};

% separately:
DATA.Xa = [DATA.ASC,(DATA.TYPs==-1).*(DATA.TREAT==0),(DATA.TYPs==-1).*(DATA.TREAT==1),(DATA.TYPs==0.5).*(DATA.TREAT==0),(DATA.TYPs==0.5).*(DATA.TREAT==1), DATA.NTYPs==-1, DATA.NTYPs==0.5,  DATA.WT7, DATA.WT3, DATA.RP2, DATA.RP3, -DATA.PRICEs];
EstimOpt.NamesA = {'Status quo - alternative specific constant';'Typical bird species: 0 -> -10 - certain';'Typical bird species: 0 -> -10 - uncertain';'Typical bird species: 0 -> +5 - certain';'Typical bird species: 0 -> +5 - uncertain';'Non-typical bird species:0 -> -10'; 'Non-typical bird species: 0 -> +5'; 'Waiting time reduced: 15 -> 7'; 'Waiting time reduced: 15 -> 3'; 'Number of rest-stop benches: doubled'; 'Number of rest-stop benches: tripled'; '- Cost (10 EUR)'};

% separately - part 1:
DATA.Xa = [DATA.ASC,(DATA.TYPs==-1).*(DATA.TREAT==0),(DATA.TYPs==-1).*(DATA.TREAT==1),(DATA.TYPs==0.5), DATA.NTYPs==-1, DATA.NTYPs==0.5,  DATA.WT7, DATA.WT3, DATA.RP2, DATA.RP3, -DATA.PRICEs];
EstimOpt.NamesA = {'Status quo - alternative specific constant';'Typical bird species: 0 -> -10 - certain';'Typical bird species: 0 -> -10 - uncertain';'Typical bird species: 0 -> +5';'Non-typical bird species:0 -> -10'; 'Non-typical bird species: 0 -> +5'; 'Waiting time reduced: 15 -> 7'; 'Waiting time reduced: 15 -> 3'; 'Number of rest-stop benches: doubled'; 'Number of rest-stop benches: tripled'; '- Cost (10 EUR)'};

% separately - part 2:
DATA.Xa = [DATA.ASC,(DATA.TYPs==-1),(DATA.TYPs==0.5).*(DATA.TREAT==0),(DATA.TYPs==0.5).*(DATA.TREAT==1), DATA.NTYPs==-1, DATA.NTYPs==0.5,  DATA.WT7, DATA.WT3, DATA.RP2, DATA.RP3, -DATA.PRICEs];
EstimOpt.NamesA = {'Status quo - alternative specific constant';'Typical bird species: 0 -> -10';'Typical bird species: 0 -> +5 - certain';'Typical bird species: 0 -> +5 - uncertain';'Non-typical bird species:0 -> -10'; 'Non-typical bird species: 0 -> +5'; 'Waiting time reduced: 15 -> 7'; 'Waiting time reduced: 15 -> 3'; 'Number of rest-stop benches: doubled'; 'Number of rest-stop benches: tripled'; '- Cost (10 EUR)'};

% SD baseline:
DATA.Xa = [DATA.ASC,(DATA.TYPs==-1),(DATA.TYPs==-1).*(DATA.TREAT==1),(DATA.TYPs==0.5),(DATA.TYPs==0.5).*(DATA.TREAT==1), DATA.NTYPs==-1, DATA.NTYPs==0.5,  DATA.WT7, DATA.WT3, DATA.RP2, DATA.RP3, -DATA.PRICEs];
EstimOpt.NamesA = {'Status quo - alternative specific constant';'Typical bird species: 0 -> -10';'Typical bird species: 0 -> -10 - uncertain';'Typical bird species: 0 -> +5';'Typical bird species: 0 -> +5 - uncertain';'Non-typical bird species:0 -> -10'; 'Non-typical bird species: 0 -> +5'; 'Waiting time reduced: 15 -> 7'; 'Waiting time reduced: 15 -> 3'; 'Number of rest-stop benches: doubled'; 'Number of rest-stop benches: tripled'; '- Cost (10 EUR)'};

% Xm:
DATA.Xm = [DATA.GENDER, DATA.AGE, DATA.AGE.^2, DATA.CHILD_yes, DATA.CHILDREN, DATA.HOUSEH, DATA.INC, DATA.INC.^2, DATA.EDUC, DATA.EMPLOYEE, DATA.SELF_EMPL];
EstimOpt.NamesM = {'male','age','age^2','children > 0','no. of children','household size','income','income^2','tertiary education','employee','self employed'};
% DATA.Xm = [DATA.AGE, DATA.INC];  
% EstimOpt.NamesM = {'age','income'};
DATA.Xm = DATA.Xm - mean(DATA.Xm);
DATA.Xm = DATA.Xm ./ std(DATA.Xm);

DATA.Xs = DATA.TREAT;
EstimOpt.NamesS = {'Uncertain treatment'};


%% ****************************  specifying input ****************************


INPUT.Y = DATA.Y;
INPUT.Xa = DATA.Xa;
INPUT.Xs = DATA.Xs;
INPUT.Xm = DATA.Xm;


%% ****************************  sample characteristics ****************************

EstimOpt.NCT = 6;
EstimOpt.NAlt = 3;
EstimOpt.NP = length(INPUT.Y)/EstimOpt.NCT/EstimOpt.NAlt;


%% **************************** estimation and optimization options ****************************

EstimOpt.ProjectName = 'WTP_jointly';
EstimOpt.ProjectName = 'WTP_separately';
EstimOpt.ProjectName = 'WTP_separately-part1';
EstimOpt.ProjectName = 'WTP_separately-part2';
EstimOpt.ProjectName = 'WTP_SD_baseline';
EstimOpt.ProjectName = 'WTP_SD_Xm';
EstimOpt.ProjectName = 'WTP_SD_Xm2';

[INPUT, Results, EstimOpt, OptimOpt] = DataCleanDCE(INPUT,EstimOpt);

EstimOpt.NRep = 1e4; % number of draws for numerical simulation
% OptimOpt.MaxIter = 1; % maximum number of iterations

% OptimOpt.Algorithm = 'trust-region'; %'quasi-newton'
% EstimOpt.NumGrad = 1; % 1
% OptimOpt.GradObj = 'off'; % 'off'
% OptimOpt.FinDiffType = 'central'; % 'forward'
% OptimOpt.Hessian = 'user-supplied'; % 'off'
% EstimOpt.HessEstFix = 1 ; % 0 = use optimization Hessian, 1 = use jacobian-based (BHHH) Hessian, 2 - use high-precision jacobian-based (BHHH) Hessian 3 - use numerical Hessian

try


%% ****************************     MNL     ****************************


EstimOpt.WTP_space = 1;

% SD2:
B_backup = [-0.350015461659920;-0.621943877261575;-0.200254897051465;0.0173042203524712;0.249311774951292;-0.390257564201790;0.00833075643390034;0.206407646788403;0.115441054703763;0.0483270566437276;-0.133969050757439;2.56575082782090;0.106385700853271;-0.171416533097348;0.0778350470477675;-0.0397265909728059;0.0373986206118108;0.0759220465391303;0.0806615216838902;0.0289127984253773;0.0342806003613602;0.00379633829354428;0.0496060079149573;-0.184661973860413;0.600781704895493;-0.252435173281861;-0.726841647426114;-0.548181547376124;1.30488841191319;-0.640357978838366;-0.344395930562659;0.201989351493139;0.322469637164471;-0.343873002850449;-0.179849537628665;-0.751302299504288;-0.691139861813404;0.250399187634419;0.699524177908372;0.485862054259956;-1.39077955652309;0.758975644991033;0.266359757269837;-0.304119890459966;-0.441024035185271;0.489898535986381;0.251657141603824;0.585982159885810;-0.0132428222704207;-0.00151938439118960;-0.0838629018963442;-0.0918700853739942;-0.0854628512101054;0.0716125403856191;0.00222308513904713;-0.168581282638755;-0.141628400997822;0.0486957180977832;0.0701595252594012;-0.108426608547167;0.0575256179999782;0.0289788480720080;-0.0965549159035307;0.0718659297334535;0.00539484000786145;-0.0522616311392666;-0.0325083768745330;0.0583812883180771;0.141772358305449;0.0498013492098368;-0.0129348616187964;0.167774933602084;-0.0525745528658238;0.0774060395910947;0.0612685148689372;-0.0470691551120723;0.0341347260793099;0.0968717007329408;0.0427815906912790;-0.0131528657632415;-0.0537164451089480;-0.0420939645211695;-0.00182067201857253;0.0437954941904262;-0.198592521444935;0.0486108956313307;0.0730515502995053;0.00216162287750752;0.0814824466572561;-0.146832599477481;0.0564268868180643;0.0140285088621080;0.0373254453886769;-0.187059381253748;-0.0548443702396233;0.200421779650153;0.0964777473139799;-0.113428112726241;-0.227834275332850;-0.0555810935713022;-0.122063355242242;0.0369965846684431;-0.0752039600849196;-0.112323477166761;-0.0765179117080340;0.194449722307140;-0.0272369854142810;-0.301751679718837;0.169164830174796;-0.0250434391905466;-0.147404650178797;0.0171227270786123;0.0294659900360840;-0.0754859377207880;0.0450355035811767;0.0295628795561009;0.0287575155389290;0.0224057610237705;-0.00690589058501231;-0.349204704495119;-0.0603564225017357;-0.0890075976308428;0.167583809797161;0.0845393003000787;-0.0879447852452050;0.0862716530970329;-0.0571598815878329;0.00188212072180485;-0.0281392101401972;0.0841140028176094;0.00263097382006613;-0.0596450984662989;0.146149666793436;-0.136091983842192;0.0816772932859105;-0.0316487038460393;0.0299975332835904;-0.000661096536510555;-0.00449379300403071;0.0838289417838265;0.114176282446360;0.0649663869425472;0.0269887918623010;-0.103321936355608;-0.489514629225810];
BAtmp = zeros(size(INPUT.Xa,2),size(INPUT.Xm,2));
BAtmp([3,5],:) = 1;
EstimOpt.BActive = [ones(size(INPUT.Xa,2),1);BAtmp(:);1];
B_backup = B_backup .* EstimOpt.BActive;

Results.MNL = MNL(INPUT,Results,EstimOpt,OptimOpt);


%% ****************************     MXL_d     ****************************


% jointly: -2265.7486
B_backup = [-0.408204755386592;-0.682848341927149;0.183678392649979;-0.429459654453931;0.0102315543169048;0.196631008174527;0.0542132609192236;0.112493596310296;-0.0786456580532110;3.56424552413772;0.651363266143327;0.533650816982040;0.333417363907236;0.409600670511497;-0.0254482579167197;0.128424244607124;0.225973892351824;0.227400764417690;0.478700045454766;2.10767359893526;-0.824061233594193];

% separately: -2240.2573
B_backup = [-0.451483299000238;-0.562156462384929;-0.691691970054240;0.0415159292847442;0.351837498909356;-0.438597991009603;0.00448418324851255;0.224567355047323;0.0615836118733375;0.0373441106065059;-0.153798526945096;4.09285087903876;0.638668151882744;0.323550548259545;0.710977108384071;-0.182892540286463;0.453566083553192;0.374194064822474;0.0326829567074358;-0.124081604217804;0.344011378773296;0.196906633858965;0.493991122600743;-2.61945756005006;-0.565853552379963];

% separately - part 1: -2252.3968
B_backup = [-0.425357369649376;-0.520397492222217;-0.782579284607616;0.156537810193022;-0.453871089946582;0.00330600312341112;0.193669773362049;0.0511578150264945;0.0917721993171109;-0.0662491241449087;4.38725252203878;0.650690291858165;0.335651017936031;0.674791681796482;0.262593619220278;0.423321717545056;-0.0423332879195010;-0.157749074159525;0.263579480730532;0.221867570085524;0.513886783468869;2.58929477788956;-1.04199728931555];

% separately - part 2: -2248.5930
B_backup = [-0.442482355707739;-0.634463333161959;0.0216461631855049;0.351492639614151;-0.387325494349586;0.000952665318703418;0.198934549881304;0.0814441377062921;0.0732910817875979;-0.165298611482434;3.84305260460480;0.641459481642289;0.500240826078311;0.116332580590205;0.471645475776923;0.358784815866925;0.0308885077470015;0.148171702047581;0.200076146529025;0.167621227962121;0.419169398699655;2.55420890029325;-0.608989091339977];

% SD (baseline model with deviations from no difference): -2241.1433
B_backup = [-0.451486892335384;-0.570159747884977;-0.138009495184076;0.0445045064016782;0.274758331074506;-0.436162003047471;0.00369373317183709;0.224752357581863;0.0772151147080639;0.0475906872058525;-0.154825848559728;4.49319192613714;0.668448063009279;0.328188012618882;0.592718302112278;0.118406393775907;0.438654759727700;0.398743532394632;-0.0202965497535892;0.103108406700137;0.319738478716460;0.260681500894808;0.484159215895297;2.88774207907085;-0.628458025066497];

% SD: -2146.3364
% B_backup = [B_backup; zeros(size(INPUT.Xm,2).*size(INPUT.Xa,2),1)];
B_backup = [-0.456898385655558;-0.543714632639827;-0.151472996516391;0.0456091354914319;0.293290500495489;-0.403619126407523;0.0317314059307837;0.215568908059020;0.0869534295502238;0.0672437839392184;-0.128289579757973;4.39801355357751;0.606491487636558;0.249607435032437;0.515214285514701;-0.152049051758986;0.454336390506358;0.359053402168140;0.0447768797247834;-0.0104640341239160;0.258313075518086;0.171646340085336;0.362987347504738;2.81043602044596;0.0211523025877691;-0.100559710880656;0.0521266853515421;-0.0558936906701854;0.0795495974188036;0.0897886930906199;0.0388406877302476;0.0127304893918226;-0.00314971726710279;-0.00705061634132205;0.0271190689801616;-0.202512987119950;-0.0353911114384099;-0.0430664358582919;-0.353280695428565;-0.0621470386096435;0.186031484252321;-0.0760128094022012;-0.215151640446145;-0.141430604957644;0.0833149899255159;-0.163743658207559;0.270701362749749;0.605237741435477;-0.0287640742803412;0.0839346989447689;0.325750948520499;0.0455020418264202;-0.333419193336395;0.161534906093582;0.128425050804718;0.0813208221577436;-0.188414824299751;0.269257932319720;-0.193336501603765;-0.467178995660503;-0.0474149717311201;-0.0223118710565295;-0.0129834125538979;-0.117465231967790;-0.0184629237870767;0.0641852764370854;-0.0330467177778935;-0.0628138902293445;-0.0666982027016914;-0.00936875617735975;-0.00710148565841772;0.403899339199929;0.0827778103273624;0.0125209945299428;-0.104437314106790;0.0769416789062315;0.0471955118690629;-0.0623433840816738;0.0204175522623624;-0.00638395881502969;0.0353748824748919;0.0688100855169556;0.0308261567144123;-0.136593187732646;-0.0453543305789726;0.0830403636817057;0.0799142506419296;-0.0133955332359015;-0.0430063327081189;0.108358036954649;-0.0148034669371020;-0.00861484055849713;-0.0499818479951422;-0.0356386306277516;0.00549434554409994;0.410539144207988;-0.0141663768059839;-0.141461948324674;0.136994312649463;0.0204727837718958;-0.0384199937530188;-0.189908718995018;0.125722177433981;0.0969262380387189;0.130002348902484;-0.0179848763193725;0.0600726885489055;-0.896913433942823;-0.00495367651748429;0.0293875379017641;-0.220829608932282;-0.0430882860813141;0.0415788572966736;0.0743618172230649;-0.117103359856723;-0.146950566714721;-0.151876332642477;0.0590701317770369;-0.109034826550551;0.639951387334350;0.0741896563148154;0.0620520282542748;-0.199799372625758;0.0616576682502649;-0.118055096050010;-0.0153901178093031;0.0469232484552181;-0.0139255796199450;0.0229419585230610;0.0237518553108876;-0.00161386146642043;-0.390078496623584;-0.0492854719880841;-0.0449642105860253;0.0442783500217468;0.0236203134371058;-0.0305708284508736;0.0507314187366745;-0.0521482156745106;0.00287215252574472;-0.00955932371148848;0.0256047914547078;-0.0285532796537813;0.173361552515566;0.0204230125822221;-0.0497297360008598;0.0312512273907852;-0.0462123190283200;0.0204150675986973;-0.00435372263912208;-0.0200794288386575;0.0345493892521627;0.0913708828127682;0.0115771932529730;0.00119002584686622;0.0526630869353015;-0.704908092467748];

% SD2: -2224.3957
BAtmp = zeros(size(INPUT.Xa,2),size(INPUT.Xm,2));
BAtmp([3,5],:) = 1;
EstimOpt.BActive = [ones(size(INPUT.Xa,2)*2,1);BAtmp(:);1];
B_backup = B_backup .* EstimOpt.BActive;
B_backup = [-0.444088076965502;-0.497068617625211;-0.151796729058582;0.0708335342234283;0.308260225835580;-0.408094178228968;0.00339036007172677;0.222472999158437;0.109599587699494;0.0687020664230315;-0.132228690670479;3.87028215063876;0.628628936191142;0.253581173295853;0.502099325233335;-0.138571564672259;0.492737602653287;0.410037273679097;-0.0114031112015058;0.0582046208123209;0.242071034900488;0.146611142234688;0.293569392567777;2.81378914270792;0;0;-0.0426187172285450;0;0.0263479104663509;0;0;0;0;0;0;0;0;0;-0.380930922503055;0;0.242973284769063;0;0;0;0;0;0;0;0;0;0.378841288602891;0;-0.308885138342377;0;0;0;0;0;0;0;0;0;-0.0197171583833481;0;-0.207044213440222;0;0;0;0;0;0;0;0;0;-0.0726057567855275;0;0.221289323754705;0;0;0;0;0;0;0;0;0;0.136426675356211;0;-0.0594717466042931;0;0;0;0;0;0;0;0;0;0.0407557814001820;0;-0.115093137863440;0;0;0;0;0;0;0;0;0;-0.191967214965443;0;0.0960507996784905;0;0;0;0;0;0;0;0;0;-0.135446628294084;0;-0.0566204563928747;0;0;0;0;0;0;0;0;0;-0.00403776745743874;0;0.0239393279671766;0;0;0;0;0;0;0;0;0;0.0159320951979113;0;-0.00811937452724569;0;0;0;0;0;0;0;-0.389051280944570];

OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
OptimOpt.Hessian = 'user-supplied'; % 'off'

Results.MXL_d = MXL(INPUT,Results,EstimOpt,OptimOpt);

OptimOpt.Algorithm = 'quasi-newton';
OptimOpt.Hessian = 'off';

Results.MXL_d = MXL(INPUT,Results,EstimOpt,OptimOpt);


%% ****************************     MXL     ****************************


EstimOpt.FullCov = 1;

% jointly: -2158.3520
B_backup = [-0.542448645154386;-0.653308022422918;0.215293606584080;-0.446644937160982;0.0303269495008736;0.193408805827204;0.0775285091070252;0.0981211161645970;-0.0715031138031082;2.24410908569460;0.731614839830602;-0.0754200725850033;-0.0240963362615847;-0.183264239152448;0.00876008630856109;-0.0599283707656338;0.0323379778054924;-0.0232884687542077;-0.0750481496301886;0.451326366565759;0.499608598645087;-0.183932733328658;0.203070648578456;-0.0263703129686406;-0.0408855733348068;-0.00890697559645890;-0.122260938535876;0.0566641215121840;1.19667140289399;0.124952529328207;-0.0658521286451974;0.0326358596336197;0.00568246809850199;-0.0287693757571114;0.0805317350588396;0.120870738394535;-0.110902596730338;0.338325134124792;0.00799244526316095;-0.0833073353621951;-0.145531242652971;0.00800404773376760;-0.0189257542109947;0.796994480361530;-0.0676379743083589;-0.0206195343142384;-0.0292989913854683;0.0146311298384243;0.107113753479319;-0.00748685414097326;-0.141335715724761;-0.122760472640168;0.116194891058451;0.0228124914359391;0.250548763427851;-0.0165807753124182;-0.0239298422182219;0.0332530061293290;-0.0592017346804948;-0.00294790778451429;0.0961299114064680;-0.156471416271770;0.0550257858222000;-0.0795316246426946;-0.0401557554527194;-0.195793689705988];

% separately: -2129.0597
B_backup = [-0.549824531905789;-0.459906623034329;-0.728080732414921;0.0809541585151653;0.392928843074105;-0.489113812205379;-0.0169601358025820;0.168302747881194;0.105402843869456;0.0626687263752001;-0.165401390602099;2.90494246635321;0.726950806739140;-0.0743746061962121;-0.116482549857427;0.00634322640760871;-0.159722489261788;0.0165757418264803;0.0217010586169775;-0.0263448989154960;-0.0240260650610400;0.0103071667186413;0.0742056025965613;1.32192630467890;0.334489609235666;0.142076092628017;0.0461121766582778;0.128847271111382;0.216251747298167;-0.00209939116929908;0.189309149322038;0.124919134119865;-0.00270583308526272;0.150465249153340;0.585403929045878;0.628197633467800;-0.217232346377123;-0.187169620593598;0.131232240097309;0.00350717552147641;0.0923053511680923;0.0541797740114129;-0.228529409921273;-0.0874568497228733;1.10714019466153;-0.101892546340075;-0.135737120816204;0.133070204666268;-0.00504412667262855;0.0223816916815627;0.0167760532353777;-0.0488185889984379;-0.0450107492733315;0.134044556357630;-0.178011936891706;-0.0319429612671316;-0.0464621879864838;-0.0687451883868917;-0.0304845289146583;-0.0254808504508185;0.0825249693030880;-0.159859559905580;0.280104213389632;0.0203239374064140;-0.128752045297745;-0.231242109163214;0.0529542807405812;0.0758253336076453;0.681760543810408;0.0564050490050897;-0.0333958014038189;0.0162593460535918;0.0963377700033784;-0.0620596678846206;0.299397076106881;-0.00832992857205238;-0.00925158499101661;0.0128528517378631;-0.000491971275699345;0.00855541244264050;-0.0203462454329450;0.0381817969127396;0.0746714569718845;0.0212810411791884;-0.0324550999238015;0.0147358001415921;-0.0560854814487084;0.123144477790025;-0.102282563782947;0.0110131511987355;-0.306051334745589];

% separately - part 1: -2138.3165
B_backup = [-0.571438909740737;-0.352783908468514;-0.810508387885878;0.239503311713757;-0.475408133682776;-0.0243824564168645;0.154408334523218;0.0670629136295143;0.102343940733748;-0.114904705353323;3.05430661849441;0.659847393046672;-0.0618110625098614;-0.0867538563022276;-0.0606561142669090;0.0540004046598498;0.0806276683118633;-0.0348140761438789;0.0436356377207331;0.0408759236818281;0.0755522607702821;1.26875142810419;0.368906172779398;0.109299374156149;0.129035883488659;0.211024310644909;0.0231301524151557;0.172592910282532;0.107148163551139;0.0481407029734268;0.224447362202671;0.302595964290091;0.697929850692075;-0.232075375173992;0.275511952379178;0.0368430737009720;0.0614789052243169;0.0414395797810243;-0.167777198421407;-0.0537142897294518;1.29901812941417;0.0720637507992425;-0.0419427088943140;-0.00604860367847973;-0.159214247980262;-0.138527515445425;0.0805600358125069;0.126261561673685;0.443653992841519;0.274895038963380;0.0217049046867399;-0.0713855989971242;-0.190467372565075;0.0399712653240621;-0.0111615997418099;0.500920344560616;0.0805329629925255;0.0376134451722849;0.0465154416387315;0.0660000423552475;-0.0217935321107744;-0.0939510647126968;-0.0131278086894160;-0.0231722897172752;-0.0212849991157954;0.0917676382923353;-0.109506518298743;-0.00869973266049242;0.0879549206491656;0.0490331440836605;0.175007340279258;0.0566012624364668;0.0616131403158645;0.113027954017406;0.0492274041606661;-0.132881806431409;0.0385020024757091;-0.571574167963206];

% separately - part 2: -2141.4327
B_backup = [-0.556818997424461;-0.603086821494114;0.0328144846264241;0.426046105855878;-0.442554264481747;0.0280660576343738;0.196517993384912;0.117226732597579;0.0850066455134812;-0.160775876540269;2.59297721727174;0.725827519189405;-0.0342859473672109;0.0171616270014348;-0.176269666105655;-0.0488565359873196;0.0342237640462839;-0.0560330881689439;-0.0367033827303810;-0.0314178377367267;-0.0164514422720566;1.12336187883590;0.474846934318445;0.0430510177015622;-0.328470627290652;0.190855036252044;-0.0375565247677993;0.0655488640889730;0.0371317053455123;-0.154249732837133;0.150902331509768;0.992581985427923;0.161489979916174;-0.323548409966884;-0.0972411118127741;-0.0674728424759798;-0.180941096185231;-0.124285809786770;0.0878829394448094;0.144707770122295;-0.472159402358313;0.0333038045816700;-0.0634473367999883;-0.0480971727908784;0.0928217312960653;0.0835327466941827;-0.0896662958373632;0.0456785040269797;-0.302587842577863;0.316768179640150;-0.0326057675006264;-0.0857059045322677;-0.168061139160878;0.0606804764166671;0.113250719377541;0.879576293876196;-0.0201285545869592;-0.0838122070561408;-0.0321727458442068;0.0573215856369216;-0.0286176058137374;0.174809181232706;-0.0450952287577140;-0.0606426399527044;0.0263729107934308;0.0829356863088628;-0.0243292023972492;0.00982766507802428;-0.0200090993632552;-0.0445086177126511;0.0594503616420378;0.00141402252694299;-0.0480882311509322;-0.0165388076924682;0.0237168657586166;0.0264683430623051;-0.0859452149943661;-0.0939807821276926];

% SD (baseline model with deviations from no difference): -2131.2895
B_backup = [-0.545521496611337;-0.487501463898166;-0.254264797333963;0.0747619215932696;0.349760150311749;-0.495811501797084;-0.00590388506735274;0.179285416504056;0.103963704802026;0.0595988199363453;-0.173586393826968;2.73882762725667;0.662588110707497;-0.0561397837151012;-0.0356377073750245;-0.00127455923659569;-0.184539389135017;0.0182670579747946;0.0138370534476299;-0.0552718989762155;-0.0278486978768676;-0.00529352627989817;0.0544741956793433;1.10828648687896;0.344543662365785;-0.0855897234375612;0.0524715519935135;0.0260862977832768;0.206516893566693;-0.0174998129816013;0.106436707802796;0.0912138859724912;0.00585186011038553;0.150186315546443;0.909969281009220;0.599966618006462;-0.202766713860822;-0.0393487335128139;0.124725925392937;-0.00887715145033140;0.0616905716727234;0.0222994274123860;-0.219755722410435;-0.0954572597812215;0.932510559509405;-0.0815711645728314;0.210331590040638;0.00929126716892993;0.0490962856367919;0.117693870851565;0.0899651864786776;-0.0873105252635755;-0.0656148774561142;-0.203144106176061;-0.0726424241805012;0.0255793278686813;-0.0154507784901672;0.00108750495222186;-0.0386954607912293;-0.00468145061871045;0.0174996301642516;-0.148019309070728;0.304423563128053;0.0140555288250934;-0.0525721022961967;-0.204138289905006;0.0364220589940599;0.0620775295080099;0.538225682999680;0.0161758199899644;-0.0637189307485094;-0.0349844803113239;0.0398509445647130;-0.0259270111279951;0.187400278998942;-0.0244627564796615;-0.0866614242103464;0.0157016576338377;0.0515486697352815;0.0287938654825426;-0.0132155099394261;0.0312496575239437;0.0819398964703099;-0.254485421558584;-0.106766038695717;0.100304171836935;-0.267545019033436;0.101360378068037;-0.114837469729081;-0.0983842113728330;-0.375386807873296];

% SD: -2038.9856
B_backup = [B_backup; zeros(size(INPUT.Xm,2).*size(INPUT.Xa,2),1)];
B_backup = [-0.546520636836274;-0.467266783258727;-0.310962874364896;0.100790775627312;0.231681699798261;-0.489422165109158;-0.000995376010375246;0.163357133259925;0.0868400460610764;0.0772711557107552;-0.136226140144268;3.10506532350319;0.628594998448977;-0.0750384228007214;-0.0579303866116503;-0.0368870679145933;-0.0280772149709847;0.0226759036255967;0.0447691329488141;-0.0271216238200061;-0.0401396771940813;-0.0200653215440920;-0.0158646078359545;1.12547100949435;0.314473194311749;-0.110109103323385;0.0409225501214625;0.0399675771286097;0.218423386504612;0.0284991217656999;0.0883144097322677;0.0430027039792701;0.0473720938333660;0.184140565462302;0.858215080669540;0.602142807574855;-0.267071440670499;0.133934037307574;0.210818922778482;0.0134759717171913;0.0600597344360047;0.00122223985641472;-0.177296734657066;-0.108475913636446;1.22740479161590;-0.0600721872911047;0.353607027413066;0.0402896453671597;0.0323152691578102;0.125082771900918;0.0692893786872181;0.0348064492355159;-0.0954345681515796;0.117549439277139;-0.0320832021051384;-0.0397628465330682;0.0397563503365738;-0.0327442754084763;-0.0102999471532561;0.00596695931271383;-0.0976489781885057;0.162098746634405;0.198995505577296;0.00976803590698043;-0.0555584283549195;-0.168879854858076;0.0539117766580050;0.0383116989898360;0.451014838455407;0.0541532269769509;0.0410041419671871;0.115575946531441;0.0366510294990362;-0.0569999596789662;0.0385569772212999;-0.0914457188412674;-0.0829851750734591;0.0115774180858569;-0.0518293647352209;0.293415586771406;-0.00171961109040566;-0.0338674912901535;0.0112285398493299;-0.0866548493559355;-0.0252658363478684;0.0328956968306571;-0.0985570070117732;0.0304589275851739;0.0180113123762834;-0.0524841162695591;0.0460953195793900;-0.0977195597326928;0.0765817702652727;-0.0287583424786205;0.0709155564437531;0.0638160728682221;0.0292107777602866;0.0200302252195306;0.0149141456279276;0.00198527510258401;0.0214689440338028;-0.107351843598416;0.00851218586787556;0.0536001023776212;-0.307429149274040;-0.114579538982938;0.576850572978630;-0.123127058295724;-0.182888976291308;-0.175370016295783;0.183266161352445;-0.259608648530753;0.0734448286599080;1.04085202283662;-0.0551489855661439;0.0361563004765983;0.253065905560852;0.121343169146665;-0.773404165104496;0.220860319827846;0.123697533113842;0.139436640895934;-0.280870833999823;0.385231456075074;0.0253649146451612;-0.953858590526872;-0.0520441661031729;-0.00390665913911680;-0.0228281617633210;-0.124197045736919;-0.0998755839741377;0.0697398228889186;-0.00677282247881504;-0.0955833931856327;-0.128344294653630;0.0213933341303107;0.0393767443277175;0.591485493712611;0.123123655075654;-0.0532729255208522;-0.0325700792019038;0.0801398352612947;0.0958147808910264;-0.0694244869323869;-0.00542480482903411;0.0676558778867584;0.106735661663607;0.0355752894989069;-0.0119682262023879;-0.435069625174311;-0.0660898629048328;0.137693996906472;0.0566219573835651;-0.0166382688758598;-0.0122886641903836;0.139417666059494;0.0147583984601781;-0.0337606716909669;-0.0433106018193997;-0.0320511522205129;0.0272446961450204;0.410663264208349;-0.0607976678546459;-0.117075300981265;0.168615504085619;-0.0397509802141913;0.0794388899219698;-0.212229562751434;0.0932124868805118;0.107661985987349;0.0349231518803035;-0.0363615944977434;0.0154482522249850;-0.443008292046158;0.0227385780116937;-0.0135244607760819;-0.247286098932975;0.000816059298214147;-0.0551375580601516;0.0940790512178299;-0.0907304780952366;-0.158275183049216;-0.0598715640383120;0.0822919228076991;-0.0775373981572069;0.138188795633063;0.0628098056332303;0.0500935346310239;-0.218710374701587;0.0307712822696414;-0.0711328912644465;-0.0109671408901802;0.0259955386775450;-0.0109572161604786;0.0452961679524006;6.85579631409953e-05;-0.0151374561641792;-0.272581129795381;-0.0341364189096580;-0.0377392952042091;0.0186827000523634;0.0447449850436168;-0.0661820111939294;0.0544060193758798;-0.0353638840605669;0.0152754265102652;-0.0177520204346415;0.0567542033731353;-0.0151114610295497;0.0660625683885642;0.0537941423935737;0.000577732974048266;0.00349969133789041;0.0180552323850000;-0.0755179019555944;0.00256581453926752;-0.00481917323723070;0.0606826825955480;0.0750663493946684;0.0358612820704863;0.0125440893059157;0.122694393369932;-0.496682776890763];

% SD2: -2112.2730
BAtmp = zeros(size(INPUT.Xa,2),size(INPUT.Xm,2));
BAtmp([3,5],:) = 1;
EstimOpt.BActive = [ones(size(INPUT.Xa,2)+sum(1:size(INPUT.Xa,2)),1);BAtmp(:);1];
B_backup = B_backup .* EstimOpt.BActive;
B_backup = [-0.563936238711597;-0.449076555390368;-0.313788490469938;0.0852218820741710;0.259802753537277;-0.485163968092548;-0.0107488828761211;0.165394833168765;0.0953686786776388;0.0658176421445976;-0.150548946681234;3.15495446986831;0.671109136651157;-0.0880282704118647;-0.139383866529524;-0.0233031752119379;-0.0428658481889400;0.0118574035878646;0.0106104300442899;-0.0215976656046779;-0.0181045910210281;0.0211662951238459;0.0331957506537516;1.25405480540727;0.333233142628783;-0.166306923736618;0.0823845116446034;0.0312805617560385;0.237975600284881;-0.0262368354202785;0.138571359312845;0.0561747560100523;0.0418936496654557;0.186022657920625;0.687623229707680;0.625795581037755;-0.272998944211494;0.0977156971245343;0.218968018322397;0.0173530742147944;0.0523264513768279;0.0171954381383052;-0.245465338343223;-0.120197378312858;1.46661056832807;-0.0619283171937118;0.332282715647417;0.0378730303642042;0.0282248819136304;0.153889529123659;0.0962247026556423;0.0605880834478590;-0.0406247105348926;-0.102750571672512;0.0893430026888190;-0.00346879933750805;0.0581048587409489;-0.0137687198242855;0.0291535050422412;0.0676291145873799;-0.130495873800604;0.357458254096579;0.275136149283426;-0.00575017106044576;-0.0753871638038774;-0.221943947499798;0.0644841608447330;0.0802250601724661;0.472373844300409;-0.0384435958163430;0.0293465888736640;0.0532769905616116;0.0514357959373743;-0.0275106714804819;0.132051742710841;-0.0758237202027030;-0.0940730533209103;0.0277782421984303;-0.0382784076421527;0.381549438440001;-0.0340487011031738;-0.0248262930721585;0.0706865293710245;0.0630659494195476;-0.0109347029255940;-0.0150587924261702;-0.0864603953591162;-0.0252368805032071;0.178706364911174;-0.00657235253963766;0;0;-0.0289338956280691;0;0.0130030153967315;0;0;0;0;0;0;0;0;0;-0.277408962443381;0;0.579557336308006;0;0;0;0;0;0;0;0;0;0.316251861508646;0;-0.680061241537382;0;0;0;0;0;0;0;0;0;-0.0101133701742826;0;-0.0907705272146966;0;0;0;0;0;0;0;0;0;-0.0214081750633291;0;0.104956700554190;0;0;0;0;0;0;0;0;0;0.0857179590210229;0;-0.0277835276573087;0;0;0;0;0;0;0;0;0;0.0462872321274921;0;-0.130244223152524;0;0;0;0;0;0;0;0;0;-0.150158954719442;0;0.127779234491033;0;0;0;0;0;0;0;0;0;-0.132817138567773;0;-0.0540468305600605;0;0;0;0;0;0;0;0;0;-0.0421234972155087;0;-0.00860099194234773;0;0;0;0;0;0;0;0;0;0.00212782266532009;0;-0.0668556394434207;0;0;0;0;0;0;0;-0.297209698548128];


OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
OptimOpt.Hessian = 'user-supplied'; % 'off'

Results.MXL = MXL(INPUT,Results,EstimOpt,OptimOpt);

OptimOpt.Algorithm = 'quasi-newton';
OptimOpt.Hessian = 'off';

Results.MXL = MXL(INPUT,Results,EstimOpt,OptimOpt);


sendmail('mik@czaj.org','MATLAB: D3 - done!');
       
catch theErrorInfo
   
    sendmail('mik@czaj.org','MATLAB: D3 - error!',theErrorInfo.message);
    
end




