% PEAT & NEP - 2019-01-14

clear all
clc

global B_backup;


%% ****************************  loading data  ****************************

EstimOpt.DataFile = ('peat_data_01_with_more_variables_06.mat');
DATA = load(EstimOpt.DataFile);


%% ****************************  data transformations  ****************************

DATA.missing = [isnan(DATA.limit), isnan(DATA.modif_r), isnan(DATA.intfe),isnan(DATA.ingen_r), isnan(DATA.abuse), isnan(DATA.resour_r), isnan(DATA.right), isnan(DATA.balan_r), isnan(DATA.laws), isnan(DATA.exag_r), isnan(DATA.limited), isnan(DATA.ruling_r), isnan(DATA.delic), isnan(DATA.contr_r), isnan(DATA.catas), isnan(DATA.identity), isnan(DATA.d6_bonds), isnan(DATA.d6_identify), isnan(DATA.d6_landscape), isnan(DATA.age), isnan(DATA.female), isnan(DATA.edu_), isnan(DATA.inc2high), isnan(DATA.member), isnan(DATA.children), isnan(DATA.urban), isnan(DATA.e4_happiness_), isnan(DATA.wildareas_)];
DATA.missing = sum(DATA.missing,2) > 0;

% education level 
DATA.edu1_ = DATA.edu_ == 1; % BA,BSc,or equivalent
DATA.edu2_ = DATA.edu_ == 2; % college degree
DATA.edu4_ = DATA.edu_ == 4; % MSc, MA, PhD, or equivalent
DATA.edu5_ = DATA.edu_ == 5; % secondary school beyond age 16
DATA.edu6_ = DATA.edu_ == 6; % secondary school up to age 16
DATA.edu14_ = (DATA.edu1_ + DATA.edu4_); % tertiary education (bachelor and beyond)

% household size
%DATA.f4_household_1 = DATA.f4_household_ == 1; % 1
%DATA.f4_household_2 = DATA.f4_household_ == 2; % 2
%DATA.f4_household_3 = DATA.f4_household_ == 3; % 3
%DATA.f4_household_4 = DATA.f4_household_ == 4; % 4
%DATA.f4_household_5 = DATA.f4_household_ == 5; % 5 or more

% importance of outdoor recreation to happiness and wellbeing of respondent
DATA.e4_happiness_1 = DATA.e4_happiness_ == 1; % Not important at all
DATA.e4_happiness_2 = DATA.e4_happiness_ == 2; % Somewhat important
DATA.e4_happiness_3 = DATA.e4_happiness_ == 3; % Important
DATA.e4_happiness_4 = DATA.e4_happiness_ == 4; % Very important

% frequency of engagement in outdoor recreation of respondent 
%DATA.e2_outdoor_fre_1 = DATA.e2_outdoor_fre == 1; % Never
%DATA.e2_outdoor_fre_2 = DATA.e2_outdoor_fre == 2; % Rarely (at least once a year)
%DATA.e2_outdoor_fre_3 = DATA.e2_outdoor_fre == 3; % Occasionally (at least once every 3 months)
%DATA.e2_outdoor_fre_4 = DATA.e2_outdoor_fre == 4; % Frequently (at least once a month)
%DATA.e2_outdoor_fre_5 = DATA.e2_outdoor_fre == 5; % Very frequently (at least once a week)

% previous visitation of wild (peat)land areas
DATA.wildareas_1 = DATA.wildareas_ == 1; % No, never
DATA.wildareas_2 = DATA.wildareas_ == 2; % Yes, once or twice
DATA.wildareas_3 = DATA.wildareas_ == 3; % Yes, several times
DATA.wildareas_4 = DATA.wildareas_ == 4; % I live or have lived in one of these areas

% NEP: 
% DATA.limit= We are approaching the limit of the number of people the earth can support
% DATA.modif_r= Original variable: Humans have the right to modify the natural environment to suit their needs.***
% DATA.intfe= When humans interfere with nature it often produces disastrous consequences
% DATA.ingen_r= Original variable: Human ingenuity will ensure that we do NOT make the earth uninhabitable ***
% DATA.abuse= Humans are severely abusing the environment
% DATA.resour_r= Original variable: The earth has plenty of natural resources if we just learn how to develop them ***
% DATA.right= Plants and animals have as much right as humans to exist
% DATA.balan_r= Original variable: The balance of nature is strong enough to cope with the impacts of modern industrial nations***
% DATA.laws= Despite our special abilities humans are still subject to the laws of nature
% DATA.exag_r= Original variable: The so-called ecological crisis facing humankind has been greatly exaggerated***
% DATA.limited= The earth is like a spaceship with very limited room and resources
% DATA.ruling_r= Original variable: Humans were meant to rule over the rest of nature***
% DATA.delic= The balance of nature is very delicate and easily upset
% DATA.contr_r= Original variable: Humans will eventually learn enough about how nature works to be able to control it***
% DATA.catas=  If things continue on their present course, we will soon experience a major ecological catastrophe 

% -          d6_identity (I think peatlands are part of Scotlands identity)
% -          d6_bonds (I have strong bonds with Scotland)
% -          d6_identify (I strongly identify with Scotland)
% -          d6_landscape (I like to spend time enjoying the Scottish landscape of which peatlands are a very important part)
% -          heritage (I support peatland restoration because I think peatlands are an important part of Scotland's cultural heritage)
% For all these variables: 1=completely disagree, 2=somewhat disagree, 3=somewhat agree, 4=completely agree.

% EstimOpt.NamesLV = {''};

%% ****************************  model specification  ****************************

% 2LV model
DATA.Y = DATA.Choice;
DATA.X = [DATA.ASC, DATA.poor/100, DATA.inte/100, DATA.wilde==1, DATA.conce==1, -DATA.price_/100];
EstimOpt.NamesA = {'Status quo';'Bad to good (100%)';'Intermediate to good (100%)';'Restoration in wild land area';'Restoration in area with lots of peat';'-Cost/100'};
DATA.Xmea = [DATA.limit, DATA.modif_r, DATA.intfe, DATA.ingen_r, DATA.abuse, DATA.resour_r, DATA.right, DATA.balan_r, DATA.laws, DATA.exag_r, DATA.limited, DATA.ruling_r, DATA.delic, DATA.contr_r, DATA.catas, DATA.identity, DATA.d6_bonds, DATA.d6_identify, DATA.d6_landscape];
EstimOpt.NamesMea = {'limit','modif_r','intfe','ingen_r','abuse','resour_r','right','balan_r','laws','exag_r','limited','ruling_r','delic','contr_r','catas','Identity','Bonds','Identify','Landscape'};
DATA.Xstr = [DATA.age, DATA.female, DATA.edu5_, DATA.edu2_, DATA.edu14_, DATA.inc2high, DATA.member, DATA.children, DATA.urban, DATA.e4_happiness_2, DATA.e4_happiness_3, DATA.e4_happiness_4, DATA.wildareas_2, DATA.wildareas_3, DATA.wildareas_4]; 
EstimOpt.NamesStr = {'age'; 'female'; 'secondary (higher) education - beyond 16'; 'college education'; 'university education'; 'income above median'; 'member of environmental organization'; 'children or grandchildren below 16'; 'lives in urban area'; 'outdoor recreation - somewhat important'; 'outdoor recreation - important'; 'outdoor recreation - very important'; 'previous visit to wild (peat) areas - once or twice'; 'previous visit to wild (peat) areas - several times'; 'previous visit to wild (peat) areas - live there'}; 
EstimOpt.ProjectName = '2 LV';

% 2LV model no XStr
% DATA.Y = DATA.Choice;
% DATA.X = [DATA.ASC, DATA.poor/100, DATA.inte/100, DATA.wilde==1, DATA.conce==1, -DATA.price_/100];
% EstimOpt.NamesA = {'Status quo';'Bad to good (100%)';'Intermediate to good (100%)';'Restoration in wild land area';'Restoration in area with lots of peat';'-Cost/100'};
% DATA.Xmea = [DATA.limit, DATA.modif_r, DATA.intfe, DATA.ingen_r, DATA.abuse, DATA.resour_r, DATA.right, DATA.balan_r, DATA.laws, DATA.exag_r, DATA.limited, DATA.ruling_r, DATA.delic, DATA.contr_r, DATA.catas, DATA.identity, DATA.d6_bonds, DATA.d6_identify, DATA.d6_landscape];
% EstimOpt.NamesMea = {'limit','modif_r','intfe','ingen_r','abuse','resour_r','right','balan_r','laws','exag_r','limited','ruling_r','delic','contr_r','catas','Identity','Bonds','Identify','Landscape'};
% % DATA.Xstr = [DATA.age, DATA.female, DATA.edu5_, DATA.edu2_, DATA.edu14_, DATA.inc2high, DATA.member, DATA.children, DATA.urban, DATA.e4_happiness_2, DATA.e4_happiness_3, DATA.e4_happiness_4, DATA.wildareas_2, DATA.wildareas_3, DATA.wildareas_4]; 
% % EstimOpt.NamesStr = {'age'; 'female'; 'secondary (higher) education - beyond 16'; 'college education'; 'university education'; 'income above median'; 'member of environmental organization'; 'children or grandchildren below 16'; 'lives in urban area'; 'outdoor recreation - somewhat important'; 'outdoor recreation - important'; 'outdoor recreation - very important'; 'previous visit to wild (peat) areas - once or twice'; 'previous visit to wild (peat) areas - several times'; 'previous visit to wild (peat) areas - live there'}; 
% EstimOpt.ProjectName = '2 LV no XStr';

% MXL with 2 covariates
% DATA.I1 = sum([DATA.limit, DATA.modif_r, DATA.intfe, DATA.ingen_r, DATA.abuse, DATA.resour_r, DATA.right, DATA.balan_r, DATA.laws, DATA.exag_r, DATA.limited, DATA.ruling_r, DATA.delic, DATA.contr_r, DATA.catas],2);
% DATA.I2 = sum([DATA.identity, DATA.d6_bonds, DATA.d6_identify, DATA.d6_landscape],2);
% DATA.Xm = [DATA.I1, DATA.I2];
% EstimOpt.NamesM = {'Idx 1';'Idx 2'};
% EstimOpt.ProjectName = 'Xm';


%% ****************************  specifying input ****************************


DATA.filter = (DATA.filter1==0 & DATA.missing==0 & DATA.protest==0 & DATA.filter_NEP==1);

INPUT.Y = DATA.Y(DATA.filter); 
INPUT.Xa = DATA.X(DATA.filter,:); 
INPUT.Xmea = DATA.Xmea(DATA.filter,:);

INPUT.Xstr = DATA.Xstr(DATA.filter,:); % only for extension 2

% INPUT.Xm = DATA.Xm(DATA.filter,:);
% INPUT.Xm = INPUT.Xm - mean(INPUT.Xm);
% INPUT.Xm = INPUT.Xm ./ std(INPUT.Xm);

% INPUT.MissingInd = DATA.Missing(DATA.filter,:); 


%% ****************************  sample characteristics ****************************


EstimOpt.NCT = 8; % Number of choice tasks per person 
EstimOpt.NAlt = 3; % Number of alternatives
EstimOpt.NP = length(INPUT.Y)/EstimOpt.NCT/EstimOpt.NAlt; % numel(unique(DATA.nr))


%% **************************** estimation and optimization options ****************************

% EstimOpt.eps = 1.e-6; % overall precision level

[INPUT, Results, EstimOpt, OptimOpt] = DataCleanDCE(INPUT,EstimOpt);

EstimOpt.NRep = 1e4; % number of draws for numerical simulation
% OptimOpt.MaxIter = 1e0; % maximum number of iterations

% OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
% EstimOpt.NumGrad = 1; % 1
% OptimOpt.GradObj = 'off'; % 'off'
% OptimOpt.FinDiffType = 'central'; % 'forward'
% OptimOpt.Hessian = 'user-supplied'; % 'off'
% EstimOpt.HessEstFix = 1; % 0 = use optimization Hessian, 1 = use jacobian-based (BHHH) Hessian, 2 - use high-precision jacobian-based (BHHH) Hessian 3 - use numerical Hessian
% EstimOpt.ApproxHess = 0;
    

try

%% ****************************     MNL     ****************************


EstimOpt.WTP_space = 1;
EstimOpt.Scores = 1;

B_backup = [-1.80252910794481;-0.0861949118503686;0.138919329844554;0.0869493165191395;0.117566124121839;0.727499906969457];

% Xm: -10625.4483
% B_backup = [-1.84301888064577;0.00995869504458219;0.182715722493806;0.104785070941904;0.122865675516836;0.774108690783969;-0.280922815996857;0.311519822890028;0.327302347705217;0.143311585336360;0.0173221713398934;-0.0488982197823609;-0.248528423461206;0.185029808854719;0.117722626998914;0.0471215688298989;0.0226324377179285;-0.0402316271347708];

Results.MNL = MNL(INPUT,Results,EstimOpt,OptimOpt);


%% ****************************     MXL     ****************************


EstimOpt.Dist = [0 0 0 0 0 1];

% -8814.7074
% B_backup = [-1.84721513407860;0.410697072741537;0.389446788580044;0.199251368830827;0.135575712165736;0.846939555718030;1.82633055786748;1.26859502758603;0.710282930272014;0.348969042073206;0.677587461009558;1.02739120516361];

% Xm: -8707.1559
% B_backup = [-1.86946331502616;0.429779184933109;0.384250870532756;0.193086260938219;0.146004251943240;0.872137054163899;1.71572055601641;1.14424333131926;0.537173504016610;0.279851585790632;0.619849663832816;1.10012104448534;-0.315949002036922;0.332405783555134;0.229948085381458;0.118540526504521;0.0292084806038910;-0.0938640966048061;-0.177680479575723;0.185874993019066;0.128870127869868;0.0626841259760326;0.0329689693284884;-0.0301586536627084];

% OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
% OptimOpt.Hessian = 'user-supplied'; % 'off'
% 
% Results.MXL_d = MXL(INPUT,Results,EstimOpt,OptimOpt); 

% OptimOpt.Algorithm = 'quasi-newton';
% OptimOpt.Hessian = 'off';

% Results.MXL_d = MXL(INPUT,Results,EstimOpt,OptimOpt); 
% 
% EstimOpt.FullCov = 1;

% -8329.5973
% B_backup = [-1.38555702111506;0.909604401514850;0.678183505176807;0.311196597146104;0.147299759097047;1.27466407453976;0.882587034568057;-1.22937909954759;-0.818536345910544;-0.342560971137995;-0.0604172958775630;0.627810521775552;0.920828078939620;0.547579028320618;0.164051159989967;0.0709106653106205;-0.108928250863766;0.191198175337538;0.134586686020656;-0.0116824301039868;-0.643647651083122;0.128244226355729;0.00669877638760897;0.114028996415988;0.400899521936321;-0.0619355216664595;0.744487862737035];

% Xm: -8254.7289
% B_backup = [-1.40595028469816;0.897814647498114;0.662604535929154;0.306669236310648;0.142650819237821;1.26912971725587;0.847960111478137;-1.14155253492470;-0.759156183248554;-0.314264911868520;-0.0525235372607087;0.662071960394276;0.912890706903139;0.537829891114270;0.157143327351726;0.0599257084148911;-0.0505737889410280;0.192772656077334;0.141945470548857;-0.0277694561659316;-0.564359061079924;0.120768158382504;-0.0121474620012605;0.0841452780910794;0.398248729637537;-0.0665858805718659;0.789359440482939;-0.142597265446583;0.389496107411718;0.268552165535887;0.119360485033012;0.0314684125819797;-0.0485155312384310;-0.155950314780315;0.241660308085705;0.147681076389925;0.0623840457892857;0.0397090333621436;-0.0455967906821747];

% OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
% OptimOpt.Hessian = 'user-supplied'; % 'off'
% 
% Results.MXL = MXL(INPUT,Results,EstimOpt,OptimOpt);

% OptimOpt.Algorithm = 'quasi-newton';
% OptimOpt.Hessian = 'off';
% 
% Results.MXL = MXL(INPUT,Results,EstimOpt,OptimOpt);


%% ****************************     HMNL     ****************************

EstimOpt.NLatent = 2;
EstimOpt.MeaMatrix = [1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0 0 0 0 ; ... 
                     0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 1 1 1 1]; 
EstimOpt.MeaSpecMatrix = 2;

EstimOpt.RealMin = 1;

% XStr: -35174.6904
B_backup = [-2.30999413195794;1.22100531405218;0.890178910854398;0.378214130981579;0.180643987601276;0.225109762467194;-2.05419313677452;1.55078008949373;1.13703044112525;0.495539283513373;0.135363005389987;-1.44986582733065;0.812131195041179;-0.522909948516500;-0.372903217555556;-0.147970724295010;-0.00939839609793497;0.740793222946978;-0.0879000432523945;0.0818431847635403;-0.00598071260670281;-0.0511318760599862;-0.0397982003550677;-0.0746480849618396;0.100866065766261;-0.110721687603423;-0.0276089098139753;0.129288906933918;0.235399375889677;0.427658495900660;-0.0523885825181530;0.0179776500381288;-0.0166921775876592;0.154214304249657;0.157172641080983;0.0146590575248118;-1.22439976004350e-06;-0.121409309265019;-0.0122720916461067;0.0205627276475147;0.00857655792639962;0.0167860954044436;0.0222159134703539;0.145194000751383;0.371399606481434;0.0632516247780764;0.206760312920889;0.134487437203278;0.552856150230008;-1.85184067788760;0.0825964281246732;0.341634944017571;0.461758472786086;-1.72682530262513;0.489899361588577;0.289753839611863;0.587798859257568;-2.28703940398717;0.00226079068653673;0.454529233205295;0.397319248736515;-1.47456989222252;0.394376845426208;0.355257573669455;0.873037148684080;-2.40892281668441;-0.0851523951856553;0.547012594449950;0.0966401134421520;-0.784043460014799;0.389877446099257;-0.0496955571417165;0.667836353619685;-2.57046049628120;-0.0774452638300578;0.453535555693329;0.718472067355792;-1.94599485601595;0.201759108448090;0.504426411330671;0.511535632685219;-2.80564569500265;0.0284229383876896;0.665161581090021;0.803467098890240;-2.01177887718239;0.229436287624533;0.354612672295037;0.612318584782198;-2.12390322040225;0.378862405430928;0.423959093664792;0.642611494582669;-1.88820700860694;0.162199916272393;0.270140215362189;0.868985936801024;-2.88388220530378;0.300981823843451;0.642203452328820;0.349265688558149;-1.64128357573698;0.388982424557538;0.238378637967662;0.928056921434139;-2.41877139012328;0.362652008883506;0.561269620766919;0.654237680603981;-2.61283513926501;0.0307312844839028;0.601259383029840;6.30616845659937;-11.2727845963728;1.20104730827717;1.78121718855856;3.65617431692766;-6.50904846363345;0.788242583813976;1.15482339249819;0.685442085185708;-2.33035084288401;0.0626863476241580;0.400138263184366];

% no XStr: -35297.8774
% B_backup = [-1.51694536050823;1.10183844756721;0.769349737503770;0.319662027493834;0.157237447040495;0.729685776882751;-0.00647556879495144;-0.222964915347380;-0.161069280376147;-0.0780937157501771;-0.0216756696887201;-0.107664369158317;1.00161057092975;-1.23447472638977;-0.855446040736322;-0.350490489974855;-0.115003132026515;1.03506661374109;-0.627839505458632;-1.93248754648132;0.120300161908331;0.378137310541641;-0.556536358620747;-1.80961112847735;0.532178466307541;0.329671772942735;-0.730263053963596;-2.43380396421462;0.0405947904679455;0.523532054939387;-0.504939559471878;-1.54391662968512;0.434153061896183;0.399369400474752;-1.05342466955672;-2.65170667487947;-0.0246564739356792;0.654119994611928;-0.136738527904572;-0.790104714868903;0.393971054054744;-0.0389187127357688;-0.720573618149136;-2.68515600171537;-0.0322187362523434;0.491807947967997;-0.911369685242892;-2.15428467229645;0.288248660292831;0.608961899865328;-0.519468698896158;-2.84724333520131;0.0422850584990655;0.675183191810404;-0.961735905919803;-2.20941395864079;0.315736894971414;0.440612325651452;-0.695302337550152;-2.24001725198829;0.431882772224487;0.462949212667347;-0.725741805245747;-1.98810877252587;0.207482266705476;0.315665212927416;-0.945736837220038;-3.03944672004685;0.344951100305410;0.692714299180447;-0.409686059168534;-1.68453688852119;0.410862928364446;0.259879083478275;-1.13753617718962;-2.75211736984212;0.492829201289146;0.673046804958826;-0.377399882982705;-2.36419955678145;-0.0527396435324782;0.494704937788936;-0.266301320322459;-2.13103578183015;-0.243019332541552;0.0939405803777412;-0.262217599057720;-2.01332544154080;-0.209425466357431;-0.0301341250664236;-0.346815354540183;-2.11167878690796;0.0110792314475567;0.275281042943277];

OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
OptimOpt.Hessian = 'user-supplied'; % 'off'

Results.HMNL = HMNL(INPUT,Results,EstimOpt,OptimOpt);

OptimOpt.Algorithm = 'quasi-newton';
OptimOpt.Hessian = 'off';

Results.HMNL = HMNL(INPUT,Results,EstimOpt,OptimOpt);


%% ****************************     HMXL     ****************************

EstimOpt.FullCov = 0;

%  XStr: -34236.3312
B_backup = [-1.89626306700004;0.499055292326667;0.397238584282332;0.176928779471964;0.149968623783034;0.856104295529530;1.78463260395472;0.963334517844412;-0.377103570321017;0.212397338933426;0.579260826112883;1.13759649872114;-0.466549095957933;0.395095014749247;0.304222920633994;0.154375403641067;0.0132654433482499;-0.227780469074988;-0.0174447751045503;0.289327332878794;0.160494908599763;0.109623464179554;0.00363966500972929;-0.0260112620978511;-0.101116205414114;0.108438287120339;-0.00963270273747156;-0.0345021296990713;0.00916723796336071;-0.151583083385632;0.117317378904944;-0.0832891677009048;-0.0197425349929260;0.0464457227430237;0.149085078680885;0.326786257629119;-0.0738807380348505;-0.00884476225315459;-0.0517079371639583;0.151735923850160;0.111062831208835;0.00166175873361669;-0.00713521739581910;-0.124605944728035;-0.00534833683049521;0.000994029197712206;0.0519794785597556;0.00435169191148450;0.0347493736118219;0.146331621774259;0.396276802546266;0.0791317376847995;0.215092968157360;0.0994258686539988;0.607530280619728;-1.92938577092736;0.115722729911892;0.370891039107249;0.549495602041438;-1.81296745458130;0.529360849351863;0.327626654583599;0.702785805072520;-2.42308106729327;0.0346746668426774;0.514355093753612;0.479903571474009;-1.53757372517784;0.425970040221746;0.389021188362306;1.04200978186765;-2.65653514185362;-0.0310752710640922;0.652563309333922;0.123898335099522;-0.790221040355150;0.392377832300866;-0.0422355682377702;0.730171307881441;-2.70422109508997;-0.0322283087559621;0.495723075537247;0.882593515608136;-2.14160764563038;0.277589579037370;0.596609537925746;0.508250305524830;-2.83620797259571;0.0324332055132717;0.670667279952894;0.959848480572429;-2.22481643943766;0.315038010573988;0.444376794649889;0.680213106592631;-2.23739116926566;0.426344064282435;0.457647429786033;0.726165649616703;-1.99979294260435;0.206558219274096;0.318208402202684;0.940101929341908;-3.05627851572894;0.347856098327061;0.693388207855653;0.394939286646084;-1.68253197855564;0.406386474030408;0.255201590794913;1.18209797665513;-2.82981596322462;0.511559197333335;0.699315178676604;0.727005952842333;-2.67106013169679;0.0481811771739924;0.628518558137226;6.04279722578995;-10.7881376538632;1.16563294120983;1.74793939997484;3.79769705390490;-6.71280432530700;0.817615794254616;1.20380947045987;0.726559216126024;-2.36150296629955;0.0783080044210652;0.417106164985980];

% no XStr: -34434.5639
% B_backup = [-1.79311636135488;0.431140307337496;0.386659505020159;0.193935667738693;0.146736408616632;0.871815890647319;1.64893650114178;1.10664486935127;0.633105118729744;0.296485092013905;0.639675588724088;1.03537081201670;0.389448739244512;-0.631301639879802;-0.389883432548125;-0.149869387080034;-0.0370610338045715;0.156002943764633;-0.0290559266550424;-0.310131154978586;-0.201291994937473;-0.0899560253908345;-0.0257458822735659;-0.00435082664304403;-0.620043052046832;-1.92735437761271;0.119369593270865;0.374053577596605;-0.544689653357944;-1.80020070642670;0.527446488471178;0.323095608461177;-0.710316309320090;-2.41703275858931;0.0381309595381190;0.514566154088049;-0.494352815948320;-1.53675984758462;0.429859059004677;0.393845270675607;-1.05122164680915;-2.64552578980665;-0.0246698401523426;0.651016197887702;-0.133231345902186;-0.789154213953384;0.393276670688350;-0.0400753287413037;-0.712990290736284;-2.67373189079586;-0.0351489996388555;0.487170404395203;-0.890403463016741;-2.12983595259673;0.278818223242875;0.595539829444613;-0.521022250827435;-2.84031168425234;0.0372078513682660;0.674119649816627;-0.964106302768561;-2.20843838083518;0.315481739640520;0.440711945503306;-0.700955562615582;-2.24180137060634;0.432177611703738;0.464604459842213;-0.714672990571821;-1.97846344440957;0.203844217491288;0.310490860169728;-0.955099955046238;-3.05920463962336;0.356220528157257;0.695738279120235;-0.395030541385808;-1.67561853068582;0.406064833592193;0.253755572844685;-1.18760800852164;-2.80806835996655;0.512025625793637;0.694042643018974;-0.686456191529430;-2.65123446488407;0.0453897464779123;0.618400094366755;-5.81351642970913;-11.0458171774245;1.27107218826818;1.75822897030805;-3.53317571060397;-6.58381277513670;0.845408887746474;1.18294947971445;-0.656354331512637;-2.31812469509027;0.0677085166517444;0.394035028387035];

OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
OptimOpt.Hessian = 'user-supplied'; % 'off'

Results.HMXL_d = HMXL(INPUT,Results,EstimOpt,OptimOpt);

OptimOpt.Algorithm = 'quasi-newton';
OptimOpt.Hessian = 'off';

Results.HMXL_d = HMXL(INPUT,Results,EstimOpt,OptimOpt);

% EstimOpt.FullCov = 1;

% XStr: -33797.9295
B_backup = [-1.37877840853052;0.940414273599040;0.655798144535997;0.309223113350135;0.143890393776969;1.27470221768819;0.849650894619445;-0.898063918579062;-0.572812255959754;-0.238048607831870;-0.00866150788103135;0.604731939813850;1.24642487676460;0.789230796820482;0.286060585716012;0.104785727406991;-0.221873075625733;0.108993575779882;0.202885181054330;-0.0209050030089603;-0.322479716492595;0.00622871137392246;0.228210706959253;0.0392966739594249;0.339053340622514;-0.0930081483685547;0.913225290620239;-0.173174814589969;0.368385307546965;0.245460849036863;0.116792122384745;0.0198133024583692;-0.0821869712254688;-0.0566603517464058;0.184801414019030;0.115461433590781;0.0543741644545624;0.0258504540991111;-0.0192122144926156;-0.0813609083830728;0.112695095716924;0.0104002493646369;-0.0196445832619811;-0.000693820797688122;-0.130011366361528;0.0979006694920206;-0.116335129041241;-0.0156168040722872;0.0803227594178666;0.196590005868481;0.381979706126150;-0.0628318982942418;0.0140903400672946;-0.0388842330667878;0.165833016353429;0.145139198811147;0.00214091537577208;-0.0112683722560094;-0.118722852353884;0.000447418841649852;-0.0226382260675444;0.0610037120831447;0.0357996040300400;0.0343646512388918;0.141065674731773;0.394018135889737;0.102724559329088;0.244621517302869;0.106539335842337;0.613414008939590;-1.92550020563130;0.118263047812421;0.374696601036566;0.550283047998338;-1.80641005253571;0.530652656202083;0.330354850073367;0.711534842804689;-2.42107955345647;0.0363738217153202;0.519628211233128;0.485660483386677;-1.53428921238982;0.429035759040563;0.392717030418157;1.03760940184447;-2.64053281661298;-0.0295400755308114;0.652061790631615;0.128690869657168;-0.788591536291881;0.392897208529597;-0.0407564729858567;0.730175275118325;-2.69701219870842;-0.0295742139897660;0.497091057525820;0.895106346878300;-2.14323153411405;0.283946464240899;0.605609041645694;0.507405623137746;-2.83255184988030;0.0350429139056352;0.672130248601822;0.960155899468452;-2.21288151095884;0.316364291881202;0.446349825504297;0.676842662768083;-2.22687984004244;0.426792873333652;0.458186180591941;0.731112056770890;-1.99484203065873;0.209938624274372;0.321720510312846;0.936255899225391;-3.03780180600219;0.345424208548053;0.693532930758172;0.400223480691618;-1.67997793765580;0.408805313546264;0.257950851577059;1.15466003168682;-2.78159849363446;0.502037835025787;0.688199768040750;0.711519554524106;-2.66792298303118;0.0465017910919673;0.625558743613330;6.55681432472104;-12.0172194661691;1.30472654933219;1.84244806053746;3.57063814542568;-6.50257679937868;0.809612660573908;1.15981562439464;0.720702047393629;-2.36613688410628;0.0782552264947712;0.417365813922352];

% no XStr: -34003.2038
% B_backup = [-1.39375694444425;0.854994225149049;0.625867093587123;0.294008002063713;0.135049685245951;1.25718634933092;0.821134985206873;-1.27510902624960;-0.858135385627878;-0.330613397615981;-0.0980556813227303;0.709274177171882;0.624336772452363;0.337316398672255;0.103306581329705;-0.0391065485426856;0.214901513225985;0.183587374677049;0.0744484029108076;-0.0848492523206477;-0.351290068137082;0.117383046402372;-0.0742998363749749;-0.176695423137985;0.379053932109692;-0.0551701363955922;0.813044888835076;0.229733334534580;-0.473398349366373;-0.329024787595189;-0.132199565282956;-0.0438359854639809;0.137537110716218;0.117448946444962;-0.232362192487007;-0.122058670514148;-0.0600320761729636;-0.0451784448340159;0.0200267103495950;-0.623145424265248;-1.93326660569715;0.121859849582588;0.377609087674200;-0.546480656845833;-1.80470569941511;0.529689012858733;0.327112873157087;-0.718226511064831;-2.42823564142389;0.0402741793505034;0.520395449990178;-0.495141925021141;-1.53966332554405;0.431650213229552;0.396704662292003;-1.05030842518403;-2.65497469122662;-0.0228159256732922;0.655203679979336;-0.132393899719561;-0.789124444489716;0.393287931955895;-0.0398989425532349;-0.724548432290655;-2.69066076891912;-0.0317379079441025;0.494404972500315;-0.891164669275087;-2.13882572946163;0.281943167638597;0.601084667327272;-0.519457612200436;-2.84725101703647;0.0414618030225495;0.675611997921209;-0.954925394233196;-2.20692597184440;0.314565858928790;0.440123758759694;-0.697331259617377;-2.24383097140108;0.433047590413285;0.465701748534816;-0.718469163195725;-1.98538966448632;0.206162434088206;0.314869772156774;-0.951872046416836;-3.05799160271061;0.352426270985111;0.697817906360842;-0.400684639009403;-1.67964669985387;0.407990867469191;0.257639515193712;-1.16161519585566;-2.78830615632575;0.504807353906157;0.686993107035155;-0.686779923533157;-2.65011081687704;0.0448180880815503;0.619523958155991;-5.40107629600162;-10.3296398193745;1.19806364694901;1.70197484044243;-3.65623407397348;-6.83712226225692;0.888020448210171;1.22477399817990;-0.657591838136806;-2.31610706919313;0.0657289573049866;0.395499631261189];

OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
OptimOpt.Hessian = 'user-supplied'; % 'off'

Results.HMXL = HMXL(INPUT,Results,EstimOpt,OptimOpt);

OptimOpt.Algorithm = 'quasi-newton';
OptimOpt.Hessian = 'off';

Results.HMXL = HMXL(INPUT,Results,EstimOpt,OptimOpt);

sendmail('mik@czaj.org','MATLAB: D2 - done!');
    
catch theErrorInfo
    
sendmail('mik@czaj.org','MATLAB: D2 - error!',theErrorInfo.message);
rethrow(theErrorInfo)

end