% recycling paper #3, 2019-06-15

clear all
clc

global B_backup; % this one is for storing B in case iterations are interrupted with ctrl-c


%% ****************************  loading data  ****************************


EstimOpt.fnameinput = ('data_smieci_3_1');
DATA = load(EstimOpt.fnameinput);


%% ****************************  data transformations  ****************************

DATA.SORT_cat2(DATA.SORT_cat2 == 0) = 1;
DATA.SORT_cat2(DATA.SORT_cat2 == 45) = 4.5;
% dstats(DATA.SORT_cat2,1)

DATA.FREQ_SQ = zeros(size(DATA.FREQ_now));
DATA.FREQ_SQ(DATA.FREQ_now == 1) = 7;
DATA.FREQ_SQ(DATA.FREQ_now == 2) = 3;
DATA.FREQ_SQ(DATA.FREQ_now == 3) = 2;
DATA.FREQ_SQ(DATA.FREQ_now == 4) = 1;
DATA.FREQ_SQ(DATA.FREQ_now == 5) = 0.5;
DATA.FREQ_SQ(DATA.FREQ_now == 6) = 0.5;
% dstats(DATA.FREQ_SQ,1)

DATA.FEE_now(DATA.FEE_now < 4) = 4;
DATA.FEE_now(DATA.FEE_now > 100) = 100;
% dstats(DATA.FEE_now,1)

DATA.SORT(DATA.SQ == 1) = DATA.SORT_cat2(DATA.SQ == 1);
DATA.TIME(DATA.SQ == 1) = DATA.FREQ_SQ(DATA.SQ == 1);
DATA.FEE(DATA.SQ == 1) = DATA.FEE(DATA.SQ == 1);


%% ****************************  model specification  ****************************


DATA.Y = DATA.ANS;


% Table 1:
DATA.X = [DATA.SQ, DATA.SORT == 2, DATA.SORT == 3, DATA.SORT == 5, ...    
    DATA.TIME == 1, DATA.TIME == 2, DATA.TIME == 3, DATA.TIME == 7, ...
    -DATA.FEE/4];
EstimOpt.NamesA = {'SQ', 'Sort in 2 categories (vs. 1)','Sort in 3 categories (vs. 1)', 'Sort in 5 categories (vs. 1)', ...    
    'Collect 1 times per week (vs. 0.5)', 'Collect 2 times per week (vs. 0.5)', 'Collect 3 times per week (vs. 0.5)', 'Collect 7 times per week (vs. 0.5)', ...    
    '- Monthly cost per household (EUR)'};
DATA.Xs = [DATA.INFO == 2,DATA.INFO == 3,DATA.INFO == 4,DATA.INFO == 5,DATA.INFO == 6,DATA.INFO == 7,DATA.INFO == 8];
EstimOpt.NamesS = {'T2','T3','T4','T5','T6','T7','T8'};
DATA.filter = true(size(DATA.INFO));
INPUT.Xs = DATA.Xs(DATA.filter,:);
EstimOpt.ProjectName = ' W 1.0';

% Table 2:
% DATA.Xm = [DATA.INFO == 2,DATA.INFO == 3];
% EstimOpt.NamesM = {'T2','T3'};
% DATA.Xs = DATA.Xm;
% EstimOpt.NamesS = EstimOpt.NamesM;
% DATA.filter = DATA.INFO < 4;
% INPUT.Xm = DATA.Xm(DATA.filter,:);
% INPUT.Xs = DATA.Xs(DATA.filter,:);
% EstimOpt.ProjectName = ' W 1.1 simplified T123';
% 
% DATA.Xm = [DATA.INFO == 6];
% EstimOpt.NamesM = {'T6'};
% DATA.Xs = DATA.Xm;
% EstimOpt.NamesS = EstimOpt.NamesM;
% DATA.filter = (DATA.INFO == 4) | (DATA.INFO == 6);
% INPUT.Xm = DATA.Xm(DATA.filter,:);
% INPUT.Xs = DATA.Xs(DATA.filter,:);
% EstimOpt.ProjectName = ' W 1.1 simplified T46';
% 
% DATA.Xm = [DATA.INFO == 7];
% EstimOpt.NamesM = {'T7'};
% DATA.Xs = DATA.Xm;
% EstimOpt.NamesS = EstimOpt.NamesM;
% DATA.filter = (DATA.INFO == 5) | (DATA.INFO == 7);
% INPUT.Xm = DATA.Xm(DATA.filter,:);
% INPUT.Xs = DATA.Xs(DATA.filter,:);
% EstimOpt.ProjectName = ' W 1.1 simplified T57';

% Table 3:
% DATA.Xm = [DATA.INFO == 4];
% EstimOpt.NamesM = {'T4'};
% DATA.Xs = DATA.Xm;
% EstimOpt.NamesS = EstimOpt.NamesM;
% DATA.filter = (DATA.INFO == 1) | (DATA.INFO == 4);
% INPUT.Xm = DATA.Xm(DATA.filter,:);
% INPUT.Xs = DATA.Xs(DATA.filter,:);
% EstimOpt.ProjectName = ' W 1.1 simplified T14';
% 
% DATA.Xm = [DATA.INFO == 6];
% EstimOpt.NamesM = {'T6'};
% DATA.Xs = DATA.Xm;
% EstimOpt.NamesS = EstimOpt.NamesM;
% DATA.filter = (DATA.INFO == 3) | (DATA.INFO == 6);
% INPUT.Xm = DATA.Xm(DATA.filter,:);
% INPUT.Xs = DATA.Xs(DATA.filter,:);
% EstimOpt.ProjectName = ' W 1.1 simplified T36';

% Table 4:
% DATA.Xm = [DATA.INFO == 1, DATA.INFO == 4];
% EstimOpt.NamesM = {'T1','T4'};
% DATA.Xs = DATA.Xm;
% EstimOpt.NamesS = EstimOpt.NamesM;
% DATA.filter = (DATA.INFO == 1) | (DATA.INFO == 4) | (DATA.INFO == 5);
% INPUT.Xm = DATA.Xm(DATA.filter,:);
% INPUT.Xs = DATA.Xs(DATA.filter,:);
% EstimOpt.ProjectName = ' W 1.1 simplified T514';
% 
% DATA.Xm = [DATA.INFO == 3, DATA.INFO == 6];
% EstimOpt.NamesM = {'T3','T6'};
% DATA.Xs = DATA.Xm;
% EstimOpt.NamesS = EstimOpt.NamesM;
% DATA.filter = (DATA.INFO == 3) | (DATA.INFO == 6) | (DATA.INFO == 7);
% INPUT.Xm = DATA.Xm(DATA.filter,:);
% INPUT.Xs = DATA.Xs(DATA.filter,:);
% EstimOpt.ProjectName = ' W 1.1 simplified T736';

% Table 5:
% DATA.X = [matInt([DATA.SORT_cat2 == 1, DATA.SORT_cat2 == 2, DATA.SORT_cat2 == 3, DATA.SORT_cat2 > 3],...
%     [DATA.SQ, DATA.SORT == 2, DATA.SORT == 3, DATA.SORT == 5]), ... 
%     DATA.TIME == 1, DATA.TIME == 2, DATA.TIME == 3, DATA.TIME == 7, ...
%     -DATA.FEE/4];
% EstimOpt.NamesA = [matInt({'Currently don''t sort - ','Currently sort in 2 cat. - ', 'Currently sort in 3 cat. - ','Currently sort in 4+ cat. - '},...
%     {'SQ', 'Sort in 2 categories (vs. 1)','Sort in 3 categories (vs. 1)', 'Sort in 5 categories (vs. 1)'}), ...
%     'Collect 1 times per week (vs. 0.5)', 'Collect 2 times per week (vs. 0.5)', 'Collect 3 times per week (vs. 0.5)', 'Collect 7 times per week (vs. 0.5)', ...
%     '- Monthly cost per household (EUR)'];
% DATA.Xm = [DATA.INFO == 1,DATA.INFO == 2,DATA.INFO == 3];
% EstimOpt.NamesM = {'T1','T2','T3'};
% DATA.Xs = DATA.Xm;
% EstimOpt.NamesS = EstimOpt.NamesM;
% DATA.filter = (DATA.INFO == 8) | (DATA.INFO == 1) | (DATA.INFO == 2) | (DATA.INFO == 3);
% INPUT.Xm = DATA.Xm(DATA.filter,:);
% INPUT.Xs = DATA.Xs(DATA.filter,:);
% EstimOpt.ProjectName = ' W 3.1 simplified T8123.xls';


%% ****************************  specifying input ****************************

    
INPUT.Y = DATA.Y(DATA.filter);
INPUT.Xa = DATA.X(DATA.filter,:);

% INPUT.Xm = DATA.Xm(DATA.filter,:);
% INPUT.Xs = DATA.Xs(DATA.filter,:);


%% ****************************  sample characteristics ****************************


EstimOpt.NCT = 12; % Number of choice tasks per person 
EstimOpt.NAlt = 4; % Number of alternatives
EstimOpt.NP = length(INPUT.Y)/EstimOpt.NCT/EstimOpt.NAlt; % numel(unique(DATA.nr))


%% **************************** estimation and optimization options ****************************

[INPUT, Results, EstimOpt, OptimOpt] = DataCleanDCE(INPUT,EstimOpt);

EstimOpt.NRep = 1e4; % number of draws for numerical simulation


try

%% **************************** MNL ****************************

EstimOpt.WTP_space = 1;

% Table 1: -22894.7610
B_backup = [-6.51486914169371;0.979971804009893;0.454451417615676;-0.0701439817642374;1.52497019070373;2.15043545561141;2.78216269808020;2.61526040197650;0.170583601274920;0.0527961977220587;-0.0401628648744043;-0.0676874621038994;-0.0381226337228121;0.0879933154167254;0.0392971381534518;0.0946757783921095];

% Table 2-4: 
% B_backup = [B_backup(1:end-7); zeros(size(INPUT.Xa,2)*size(INPUT.Xm,2) + size(INPUT.Xs,2),1)];
% EstimOpt.BActive = ones(size(B_backup));
% XmActive = zeros(size(INPUT.Xa,2),size(INPUT.Xm,2));
% XmActive(2:4,:) = 1;
% EstimOpt.BActive(end-numel(XmActive)-size(INPUT.Xs,2)+1:end-size(INPUT.Xs,2)) = XmActive(:);
% B_backup = B_backup .* EstimOpt.BActive;

% Table 5: -11353.7232
% B_backup = [-7.58324724532040;0.348548193182365;-0.941763359310907;-3.98827156468051;-8.10114169506497;3.19559569746689;1.60397154091674;-1.51617959786729;-9.45577767470086;2.54990695651279;3.42208674983944;0.976206644155220;-4.11219909206061;1.78483468011515;3.18766885174531;2.76005859357949;1.83342480990320;2.87927264775268;3.31327903529295;2.84515767836102;0.180059982069909];
% B_backup = [B_backup; zeros(size(INPUT.Xa,2)*size(INPUT.Xm,2) + size(INPUT.Xs,2),1)];
% EstimOpt.BActive = ones(size(B_backup));
% XmActive = ones(size(INPUT.Xa,2),size(INPUT.Xm,2));
% XmActive([1,5,9,13,17:21],:) = 0;
% EstimOpt.BActive(end-numel(XmActive)-size(INPUT.Xs,2)+1:end-size(INPUT.Xs,2)) = XmActive(:);
% B_backup = B_backup .* EstimOpt.BActive;
% B_backup = [-7.65062798405556;-2.15712687374379;-6.60911059889290;-6.13602378715458;-8.09474874119079;4.11269630824061;1.44353647578933;-2.17699063366842;-9.48695011275455;1.71803325331992;1.75650670271611;0.464937390961512;-4.09874618977862;1.72974418064090;3.25734724908753;2.49426483980470;1.91387287515091;2.86908273659730;3.29998850991560;2.86472489953990;0.186995732509415;0;2.77831563939674;4.49036654426666;2.85866428101829;0;0.574068016327598;2.95923175632798;3.56327198932009;0;0.886793533019673;1.48484619185096;-0.369739090810717;0;-0.659376382437494;-1.02658455492306;0.149543098072862;0;0;0;0;0;0;3.53901877480037;9.04858043334851;4.47639735803860;0;-2.01254747845246;-0.817082845085080;0.785661245008900;0;1.85553352545237;3.32260786356367;1.53242542002586;0;0.579568265157367;1.05555412830236;1.68066782104180;0;0;0;0;0;0;4.12339026066461;8.00444743432044;-0.0747291414127148;0;-2.09180788991858;-0.713369949611986;-1.45822092963768;0;0.627609068788690;1.84623479813075;0.845043174558090;0;0.243748550797636;-0.0728525376468677;-0.578073281944207;0;0;0;0;0;-0.0757301497820940;0.0345730286788988;-0.101710351346139];

OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
OptimOpt.Hessian = 'user-supplied'; % 'off'

Results.MNL = MNL(INPUT,Results,EstimOpt,OptimOpt);

OptimOpt.Algorithm = 'quasi-newton';
OptimOpt.Hessian = 'off';

Results.MNL = MNL(INPUT,Results,EstimOpt,OptimOpt);


%% **************************** MXL_d ****************************


EstimOpt.Dist = [zeros(size(INPUT.Xa,2)-1,1); 1];

% Table 1: -17065.6517
B_backup = [-8.38649907608000;1.87111533338762;2.23685500008356;-0.612114577296535;2.02670845612656;2.63567903720680;3.04806401232660;2.25921757483403;-0.703035409209626;8.70512678647648;2.50312108954019;3.82552408816954;7.16057031721741;1.34756656708514;1.29973755891712;1.94231449111124;2.82508521021528;1.19558512789502;0.0366938161400586;-0.0545158637043325;-0.0505781493307867;-0.0255401811884976;0.108150220247720;-0.0471953856749787;0.118859592637936];

% Table 2-4:: 
% B_backup = [B_backup(1:end-7); Results.MNL.bhat(end-size(INPUT.Xm,2)*size(INPUT.Xa,2)-size(INPUT.Xs,2)+1:end)];    
% EstimOpt.BActive = ones(size(B_backup));
% XmActive = zeros(size(INPUT.Xa,2),size(INPUT.Xm,2));
% XmActive(2:4,:) = 1;
% EstimOpt.BActive(end-numel(XmActive)-size(INPUT.Xs,2)+1:end-size(INPUT.Xs,2)) = XmActive(:);
% B_backup = B_backup .* EstimOpt.BActive;

% Table 5: 
% B_backup = [-8.61385907811965;0.0931030761998957;-1.12808139131255;-5.60770155807480;-10.4113739521411;3.91737660006614;2.05336276149451;-2.68106396284704;-10.5854372181878;2.09199045683472;3.89427569574828;-0.649249935838236;-5.42989678118644;1.92902364004503;3.65989210087732;3.27126180199024;2.02965550319989;2.72016154427742;3.12846512464740;2.30950891086493;-0.632818719319329;11.0431774630601;2.83178997842365;5.56013754385540;7.73427170158918;7.33353860714415;4.07347311965752;4.68611165605036;7.65280987534297;7.37009944104664;2.10430379390544;3.60007003526604;6.84825603708710;9.18835260493286;1.69502146344014;3.55119374535957;5.96949927690244;1.28252589614976;1.72677095642614;2.26334075111469;2.83382026781400;1.22476187320649];
% B_backup = [B_backup; zeros(size(INPUT.Xa,2)*size(INPUT.Xm,2) + size(INPUT.Xs,2),1)];
% B_backup = [-9.76261933498518;-1.92203444838708;-5.07203291333550;-8.32053805181422;-10.3423903858678;4.40815746409570;2.83817892730617;-6.15417949931644;-11.8850065776403;2.67593516415853;2.64060371462208;0.133075350160118;-5.81091462099707;2.36389574759266;3.76734944015095;3.08905027429980;1.84185444576082;2.73016015673037;3.12688531284459;2.55763612608825;-0.319865665207345;11.3482561302381;3.74100519548560;4.67688776747249;8.57995981111513;7.36702575649271;3.67706123005167;4.27503984419829;8.28008459236705;7.65066085451397;1.56149829844627;3.86723257020653;7.07958669772003;7.04071815572389;1.13586285989029;2.57476738951658;6.10735378056501;1.26235879956884;2.12541772965204;2.41811224387853;2.86393745888557;1.43383215310715;0;0.778681298784598;0.997135013552430;3.58325496215825;0;-0.141870265635892;1.39719630886358;4.41785372341423;0;-0.542772844854759;0.164416034226365;-0.554159208103309;0;-0.842912678378078;-1.46860305202769;-2.34481370025343;0;0;0;0;-0.120635956597877;0;1.70594227021275;6.94044581428961;3.79860465528738;0;-0.528990223430913;-1.07027293393444;3.17121247416805;0;-0.00134165223926565;2.06003344211374;-1.40306563274065;0;-1.24397914165581;-0.384648209853469;-0.0381731571807700;0;0;0;0;-0.155718464466737;0;3.75939715946859;6.25372298906623;-0.934645883529238;0;-0.597638849930577;-1.52672210075063;0.355348478907605;0;-0.310413672582770;1.41343983627194;-0.375130021947019;0;-0.640256549960964;-0.293464528856588;-0.597319792706655;0;0;0;0;-0.319152970430071;0;0;0];
% EstimOpt.BActive = ones(size(B_backup));
% XmActive = ones(size(INPUT.Xa,2),size(INPUT.Xm,2));
% XmActive([1,5,9,13,17:21],:) = 0;
% EstimOpt.BActive(end-numel(XmActive)-size(INPUT.Xs,2)+1:end-size(INPUT.Xs,2)) = XmActive(:);
% B_backup = B_backup .* EstimOpt.BActive;

OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
OptimOpt.Hessian = 'user-supplied'; % 'off'

Results.MXL_d = MXL(INPUT,Results,EstimOpt,OptimOpt);

OptimOpt.Algorithm = 'quasi-newton';
OptimOpt.Hessian = 'off';

Results.MXL_d = MXL(INPUT,Results,EstimOpt,OptimOpt);


%% ************************** MXL *******************************


EstimOpt.FullCov = 1;

% Table 1: -16057.7596
B_backup = [-9.54264202379635;3.22725011856600;3.81006381242390;0.588848630043415;3.18706635547496;4.37205469164887;4.55579266229394;3.88118352148730;-0.521493571118334;9.40531170504293;-0.928337680749877;-0.440572657875113;0.531441125285902;-0.210072205053151;-0.847231734234812;-1.14497360673805;-1.06951080063028;0.362263204805899;5.49412415938324;7.28338459176974;6.20786306977188;1.09405866516343;1.89395102696301;1.56410218857788;0.744924904625210;-0.418321380299155;2.74958525368494;6.76946436214465;-1.54229534187726;-2.20986367211351;-1.71444401688452;-2.22556427961384;0.0416847976929299;3.23251897949553;2.09746329736374;1.78394139426933;2.27840805401934;1.81112760842550;0.242531892923992;-2.74247321684626;-2.95423236761424;-3.24124782615219;-3.68089410317282;0.373505283046375;2.71673465445031;3.31890974584735;3.40785517718296;-0.0306273104359315;1.54608563865603;2.81035570231584;0.107021718036055;0.180125021145543;-1.01316015822864;0.182435106312132;0.236071663058741;0.0292227455614548;0.154730324155612;0.102824063743206;0.0261469566731695;0.0741873868214193;0.144851688272101];

% Table 2-4: 
% B_backup = [B_backup(1:end-7); Results.MXL_d.bhat(end-size(INPUT.Xm,2)*size(INPUT.Xa,2)-size(INPUT.Xs,2)+1:end)];    
% EstimOpt.BActive = ones(size(B_backup));
% XmActive = zeros(size(INPUT.Xa,2),size(INPUT.Xm,2));
% XmActive(2:4,:) = 1;
% EstimOpt.BActive(end-numel(XmActive)-size(INPUT.Xs,2)+1:end-size(INPUT.Xs,2)) = XmActive(:);
% B_backup = B_backup .* EstimOpt.BActive;

% Table 5: -7832.7797
% B_backup = [-9.81158212509330;0.531620948933320;-1.44162247363905;-5.11037863720568;-12.2582206317582;5.92192389302571;3.66175560078144;-2.25707767119364;-12.0898927179030;4.11106352376892;5.74242253911850;1.75394265060190;-4.78860193043117;3.83735276219284;6.23741153537321;6.04364611887756;3.41003789861512;4.49855183014791;4.84533720233173;3.95755481472231;-0.238218892680592;11.0583262443258;-0.479104306034508;-0.469925273256191;0.199372204242052;0;0;0;0;0;0;0;0;0;0;0;0;1.12026249430913;1.24957789544293;0.793686169063098;1.24700799698423;0.267366922786689;5.93844496473076;7.79532380076877;6.70165185626350;0;0;0;0;0;0;0;0;0;0;0;0;0.747496194507650;1.06359177457000;1.44449691454097;0.861746493132093;-0.428172630097798;3.38137956226983;4.65112368458209;0;0;0;0;0;0;0;0;0;0;0;0;-0.741422652671362;0.0576369147776969;0.271104536536357;0.296317463204255;0.0983850958602275;4.69408547399007;0;0;0;0;0;0;0;0;0;0;0;0;-1.21394813362377;-1.13798225397219;-0.487820438287909;-0.170234192978265;0.0157729352890917;8.23232610986168;-0.434535642133623;-1.06292625885732;-0.923246735732214;0;0;0;0;0;0;0;0;-0.580976612963565;-1.22813522739736;-0.714707824983823;-1.02788218945312;0.848399851490681;6.86265386431749;7.35207830311862;6.06064303362239;0;0;0;0;0;0;0;0;1.00577067430749;1.28505264953193;1.18028737443885;0.745087231485326;0.0321369797892333;3.55938862572208;8.67115548504351;0;0;0;0;0;0;0;0;-1.54554766692809;-2.10761404216802;-2.62093623921032;-2.97924682547025;0.0317661353945343;1.58960402172600;0;0;0;0;0;0;0;0;1.58783385777063;1.38312819793035;2.05815964458767;2.21540339599499;0.0505120350168878;7.59541119076222;-1.83227242557927;-1.91414328068576;-1.76574455859225;0;0;0;0;0.0785750326156716;-0.504323176083229;-0.560540233943350;-0.464727785468316;0.343199048613089;5.14217327012686;7.23447736789654;6.40331718081579;0;0;0;0;1.03786731933601;1.44584034094016;1.28022473056401;1.19311910431551;-0.459945165215550;2.86823870613544;4.78164202715343;0;0;0;0;-0.676300853715998;-0.697324102218485;-1.12256342854571;-0.646053354160133;0.208665074240299;4.51950193486863;0;0;0;0;0.547704548933664;-0.0758314300995882;0.536410562589080;-0.149631228496852;0.191073637815547;11.3201931152744;2.61276327392013;4.08204711380768;4.37929822231841;-0.743780485153759;-0.230195625980457;-0.262105373404770;-0.893980178472555;0.302408924620084;4.88190601744649;5.71058260326525;4.10070090047984;0.440306719958616;1.91262298580142;1.62519221022225;1.22710188556918;-0.409989400590714;1.69829499482718;5.24146227344453;-0.198917967211061;-1.17920432108400;-0.745560347419964;-1.27339233681040;-0.314296264319386;3.13912350353179;2.36452872694051;2.18371227574518;2.63208036140437;2.83516548164110;0.193723736896453;-0.507292277296312;-0.949902317571671;-1.43651487595305;-1.82254276577562;0.265956968898352;1.68348281816701;2.15251834721574;2.50450259863770;0.233210073049186;0.849843306245522;2.11980879354464;-0.225886484627572;0.587452169783333;0.0485835097565767;0.0656708152000913];
% B_backup = [B_backup; zeros(size(INPUT.Xa,2)*size(INPUT.Xm,2) + size(INPUT.Xs,2),1)];
% B_backup = [-9.87239640109007;-0.972681209437901;-4.11716737152736;-7.13424054528706;-11.4541957959761;5.95592349231715;4.29499535446963;-2.94602485212483;-11.9788939127166;4.43960073407174;4.91571155819061;1.27357135507684;-3.52617810889343;5.47631437312595;7.81422620917955;6.98095080556522;3.13880481916724;4.51881839561259;4.71626273959186;3.91840798979582;0.301720012586963;10.7904508624605;-1.50433835404706;-1.28317182891076;-1.03334817517903;-0.0413485462774303;2.07211138780648;1.38655961202652;-0.366656311540746;1.76426011793866;-0.598388795746662;-1.08134579458221;-0.934000525319567;-2.06038476928442;-2.72295406645285;-2.56764613944824;-3.32539223509121;-0.268970861666181;0.0256663215611636;-0.231855715533461;0.328505691846696;0.283237761164276;6.49114022442341;8.18730969445562;8.75652677691597;-2.66125801343736;3.62852544824675;4.42549369474024;2.47282742396163;1.00914099669310;-1.38668521699239;-1.45843955335307;-1.42594855442170;-0.585207381831014;1.73522351284589;2.01734405205082;1.45615687072182;0.318090114985589;1.61851395345349;1.47743251276906;0.244102312934317;-0.518092706030068;4.17783463791977;3.76033111580921;-0.675112401788068;1.03209246382134;-0.712749323283680;-2.11482657333493;-2.06193894896316;3.61929276376432;4.95569969067836;3.82916174929159;-0.964201582469037;-0.658091906463305;-1.59064003385525;-3.38138443979192;-0.728437382775370;-0.0865262607220557;-0.0933649787371918;-0.540481504305848;-0.146480600412903;4.69054675748027;-0.549920457226422;-0.676099119249684;-0.306339226217004;-0.795070862771441;-0.514692732368216;-1.31051349884883;-1.35563293072126;-1.13562991271907;0.943830198836032;0.0913923409072371;-0.0849211351774493;-0.617469891671582;-0.0857091182463151;-0.235491689043040;0.186605196609752;1.00276044630051;0.290912083582788;8.30979868193595;-1.42279748887074;-0.931369899592536;-1.68720397529745;0.297157603731039;0.546251335038143;1.35073888017849;3.89548462151830;-3.90867353554258;-2.45227955526742;-3.70751743699900;-2.18676221259675;-0.940836314385729;-1.45460134839557;-1.01491280883561;-1.50619787375751;0.928711952610141;4.99925422800382;5.71393767230367;5.82663588337572;-1.45339288504301;0.761778279750638;0.345368985672093;-0.382720108036802;-1.50413064849389;-1.53712091740307;-2.60853429448072;-1.53216871726242;0.586049326277203;-0.268046190068337;0.160881851299723;-0.315812253395892;0.0932204716827703;2.28341180017075;6.63698512180038;-1.48738071990940;0.194657228875894;0.573747603262488;0.386154243141177;-0.0367196920609022;0.709593426279731;0.0970068431914464;-1.69198153448409;-1.11630434618877;-0.881163044241248;-1.48012168821949;-1.80629869233180;0.247578103939759;2.18843672883352;1.09631476756355;-2.30914202553908;-2.68756662751421;-2.09614103110424;-0.607882339357833;-0.747597937377314;-0.0754745664408476;0.603973563002857;0.113093588955170;-0.463231368762907;0.144876823304840;0.749020206032313;0.519271447707755;7.38393275906043;-0.920414351465561;-0.782182331430003;-1.49499856874708;-1.64689962229937;-2.17759646506574;-2.67543937274690;-2.93384974424971;-0.0778053791127996;-0.724657080895665;-1.67027041679061;-1.60734014087389;0.693463196937145;3.90636299521406;5.89514417063093;5.77591548492811;0.875717646195179;-0.770608588777809;-0.992252039322301;0.0544527018588918;2.05043988352820;3.07342251445298;3.50087774093202;3.79522814352595;-0.187432801192671;2.26464009150441;5.43842331303476;0.246470217140468;-0.798651978534917;-0.125782244093932;2.26652722595508;-0.268127162210437;-1.70987811757882;-1.63429123211688;-2.04018125651788;-0.0367120319664651;3.34575348717303;-1.77930486057578;-0.548963071926452;-2.35924342813151;-1.68039480916752;0.983808839090079;0.388258976243376;1.01712560479021;0.792973841371740;0.324370290909288;9.89321068097735;-0.0690956577784903;1.19869112063128;3.53102069990837;-0.139951681205999;-0.292630876429471;-0.570957215834240;-0.978307875112126;0.685122160119865;0.621775671567679;0.947791732005734;2.60362945672645;0.504579945769041;1.09163530572661;0.763441427382059;1.01247219948812;-0.461478397797725;-1.08653826500801;-0.292596675908965;-1.61203408616874;-1.63094011751665;-1.39765789206975;-1.24204252206483;-0.394154802098246;2.62384085156503;1.47830756727832;1.59430378176213;1.85248678649251;2.02433542395661;-0.146063634784694;0.159408589703834;-0.243741380804875;-0.267269139283554;-0.111495818978669;0.296627727416382;1.69964545054993;2.35604632021070;1.95038503167159;0.374693650048161;0.971997077488420;1.76730108817317;0.0196844287927927;0.468723356591192;-0.598440430975994;0.411201662828756;0;-0.576442729543387;1.86086039256477;1.89776476759679;0;-0.277876790862793;0.317617247119194;2.76786196442079;0;0.0232221882201272;0.988887109674173;0.156355671979930;0;-0.618835649853727;-0.555588758602639;-0.746584404066865;0;0;0;0;-0.194417764006564;0;1.00048797967839;3.45380699967071;2.03258541819706;0;-0.363354829287747;-0.895717388514448;0.371634991502114;0;0.275751856288231;1.76569116201465;-0.239423576628286;0;-1.74405341356709;-0.600663714448069;-0.488947881110705;0;0;0;0;0.000278696819385327;0;3.21762853854714;5.53397007967237;1.09339191933492;0;-2.38747910617300;-2.70043111814109;-2.56254652454355;0;-0.841469773969572;0.330965751107984;-0.506222333113177;0;-0.682135195334020;-1.00121307637337;-0.397198559465457;0;0;0;0;-0.161544790703415;0;0;0];
% EstimOpt.BActive = ones(size(B_backup));
% XmActive = ones(size(INPUT.Xa,2),size(INPUT.Xm,2));
% XmActive([1,5,9,13,17:21],:) = 0;
% EstimOpt.BActive(end-numel(XmActive)-size(INPUT.Xs,2)+1:end-size(INPUT.Xs,2)) = XmActive(:);
% B_backup = B_backup .* EstimOpt.BActive;

OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
OptimOpt.Hessian = 'user-supplied'; % 'off'

Results.MXL = MXL(INPUT,Results,EstimOpt,OptimOpt);

OptimOpt.Algorithm = 'quasi-newton';
OptimOpt.Hessian = 'off';

Results.MXL = MXL(INPUT,Results,EstimOpt,OptimOpt);


%% ************************** FINISH *******************************

sendmail('mik@czaj.org','MATLAB: D5 - done!');
       
catch theErrorInfo
   
    sendmail('mik@czaj.org','MATLAB: D5 - error!',theErrorInfo.message);
    rethrow(theErrorInfo)
    
end