% Choosing the future: economic preferences for higher education using discrete choice experiment method
% Estimation of the Mixed Logit model:

clear all
clc

global B_backup; % this one is for storing B in case iterations are interrupted with ctrl-c


%% ****************************  loading data  ****************************


DATA = load('EDU2_DCE_01.mat');
DATA_SD = load('edu2_data_sd_all.mat');


%% ****************************  data transformations  ****************************


DATA.odl = zeros(size(DATA.ANS));
DATA.odl(DATA.O==1) = 15;
DATA.odl(DATA.O==2) = 65;
DATA.odl(DATA.O==3) = 175;
DATA.odl(DATA.O==4) = 250;
DATA.odl = DATA.odl / 100;


DATA.KLASYFIKACJA = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.KLASYFIKACJA);


DATA.dropouts = DATA.KLASYFIKACJA == 6;
DATA.maturzysci = DATA.KLASYFIKACJA == 1;
DATA.studenci = any(DATA.KLASYFIKACJA == [2,3,4],2);
DATA.absolwenci = any(DATA.KLASYFIKACJA == [5,7,8,9,10],2);

DATA.K0 = max(DATA.K,0);
DATA.S = -min(DATA.K,0);


%% ****************************  model specification  ****************************

DATA.Y = DATA.ANS;

DATA.Xa = [DATA.Z==2,DATA.Z==3,DATA.J==2,DATA.J==1,DATA.odl,DATA.S/4 == 0.25,DATA.S/4 == 0.75,DATA.D,DATA.W/4,-DATA.K0/4];
EstimOpt.NamesA = {'zgodnosc_srednia (vs. niska)';'zgodnosc_wysoka (vs. niska)';'jakosc_srednia (vs. niska)';'jakosc_wysoka (vs. niska)';'odleglosc / 100 (0;2.5)';'stypendium = 1000/4';'stypendium = 3000/4';'dzienne (vs. zaoczne)';'wynagrodzenie (2;8)/4';'-koszt (0;7)/4'}; % Specyfy names of the attributes


%% ****************************  specifying input ****************************

% DATA.dropouts
% DATA.maturzysci
% DATA.studenci
% DATA.absolwenci

DATA.filter = DATA.absolwenci;

INPUT.Y = DATA.Y(DATA.filter);
INPUT.Xa = DATA.Xa(DATA.filter,:);


%% ****************************  sample characteristics ****************************


EstimOpt.NCT = 12; % Number of choice tasks per person 
EstimOpt.NAlt = 3; % Number of alternatives
EstimOpt.NP = length(INPUT.Y)/EstimOpt.NCT/EstimOpt.NAlt; % numel(unique(DATA.nr))


%% **************************** estimation and optimization options ****************************


[INPUT, Results, EstimOpt, OptimOpt] = DataCleanDCE(INPUT,EstimOpt);

EstimOpt.NRep = 1e4; % number of draws for numerical simulation


%% ****************************     MNL     ****************************

EstimOpt.WTP_space = 1;

% B_backup = [0.347767045905516;0.481095976055091;0.0451919911706802;0.0794946174898411;-0.225670272889335;0.183754575516871;-0.352418921534522;0.723225553914921;0.920282677068097];

Results.MNL = MNL(INPUT,Results,EstimOpt,OptimOpt);


%% ****************************     MXL_d     ****************************

EstimOpt.Dist = [0 0 0 0 0 0 0 0 1 1];

EstimOpt.FullCov = 0;

% dropoutps 10k: -114993.3954
% B_backup = [0.240231209632180;0.353452155694859;0.0260636456824345;0.0273227896932328;-0.174452304197129;-0.122065242649026;0.0528100730779538;-0.354222714749799;-0.777555171502708;0.236567972940284;-0.155455181718421;0.547707971199230;0.0216191125785721;0.00386910229544769;0.274874092436606;0.339829084384939;0.460860521584928;0.486002978884654;0.995110809132179;1.19385589642879];

% maturzysci: -12539.8885
% B_backup = [0.430859454943481;0.654060117432846;0.0632608001524884;0.0538353800959774;-0.154665059718664;-0.149602527294096;0.0403953161141407;-0.182835721055434;-0.731582793348764;0.222472714390185;-0.245976085991029;0.675729683032593;0.148086699729044;0.0369228630216187;0.225789333149619;0.300366060241994;0.491578071563679;0.827755611870894;0.896718391793223;0.955276946590838];

% studenci: -37999.4446
% B_backup = [0.525948337014519;0.773084888231856;0.0669667645414938;0.0598941292705034;-0.183515958774212;-0.193228806867921;0.0569842694379443;-0.0779449036771902;-0.646016248751137;0.143981945111642;-0.430232100467085;0.916612794962671;-0.0387248669706931;-0.0251212488173434;0.332389845316840;0.345611151626003;0.505465276838237;0.915366050752407;0.948177263290532;0.956027918721656];

% absolwenci: -47425.3001
B_backup = [0.430157983538551;0.658957110941551;0.0519562166723685;0.0650581759245668;-0.173370319396916;-0.180820378218707;0.0124086384925669;-0.217895622710449;-0.636636309890551;0.211318628466271;-0.370261886343284;0.754836915376623;0.0144974122768065;0.0113989010713647;0.267724446886188;0.274042875647518;0.454790389959085;0.755108632232022;0.867679182832057;0.950910680779300];

Results.MXL_d = MXL(INPUT,Results,EstimOpt,OptimOpt);


%% ****************************     MXL     ****************************


EstimOpt.FullCov = 1;

% dropoutps: -113094.3869
% B_backup = [0.399993725139981;0.515430642441262;0.0366322730168305;0.0443946217683104;-0.208669116575854;-0.155636377014375;0.0320865151581955;-0.352707253045337;-0.663762022899963;0.272648515041627;0.429425958985876;0.661465353852985;-0.0307532630120422;0.0292504047578047;-0.0709460982496899;-0.141335845654068;-0.295315697818605;-0.0435672945797394;0.154452225347437;-0.371725640696050;0.222186563388402;0.0194870941832248;0.0162534250054605;0.0558780091705644;0.0747887515965832;-0.0334192879786558;0.0558911788384426;-0.732140947183465;-0.0391184032045431;0.0554296004307293;-0.0160657189276657;0.188554962801609;0.0242671572368910;0.112431906076597;-0.165836838075366;0.503035560089820;-0.315670770935438;-0.000879044932978615;0.0603203181063929;0.244268571239186;0.365248157968315;-0.0778754684736256;0.236207611045957;-0.350342401841391;0.167995564644380;0.110703631363686;0.164244146444344;0.0850001053066827;0.0429386193054424;0.864984621550269;0.0998197681473525;0.168716943151533;0.100214035805886;0.187148741431576;-0.173938202611615;0.135009915047010;-0.0629360409454759;0.103762744700562;-0.364368005207839;0.452511630730289;0.180133179183138;-0.258236223592010;0.385954647370606;-0.199949383089132;0.323112235711098];

% maturzysci: -12268.5996
% B_backup = [0.577582470427993;0.758218493109293;0.181898122247626;0.143497736058773;-0.198432898990508;-0.145816901974400;0.0827086880058072;-0.235850229294777;-0.602126078841977;0.241701494455612;0.526222912989273;0.879495317032290;-0.0227468712366384;0.0895522361131878;-0.0739095681921420;-0.190399215432166;-0.444838727562538;0.150044121617216;-0.0479770985014581;-0.170961079129143;0.137456017004371;-0.0363501963121392;-0.0406483452949452;0.0964859138869237;-0.00119209106016152;0.0162374369285540;-0.0637067419732774;-0.354600981102129;0.315728424888296;0.211261710162906;0.176804295347868;-0.0790901756690215;-0.0467428467657011;0.136191828444669;-0.154335164124556;0.263625344042586;-0.697705239544613;0.100758871975391;-0.0740575913373528;0.0410805911912685;0.0371231583404336;0.288196942783368;-0.121748631559983;0.0122513068804369;0.196649429406447;0.139436670474180;0.295646164983388;0.0675904826447489;0.436791674669949;-0.141854935607862;0.307751985202588;0.176789113538173;-0.0797353913145721;-0.348192593106425;-0.324649296204938;0.359878509466986;-0.478279947444809;0.169360849023691;0.0928539330686582;0.641206536018055;-0.184038748493358;0.162868923071533;0.555412819714305;-0.235198127868214;0.548989580593032];

% studenci: -37215.6448
% B_backup = [0.739792998683635;0.920772510661877;0.0938590786768468;0.0968783948564253;-0.215032669634297;-0.241567272311164;0.0441855184594589;-0.0826391173986175;-0.535009269422296;0.143299715409919;0.723806899107811;1.15043421835980;-0.00443210076940902;0.0103853717683422;-0.0152713378632224;-0.170580227035450;-0.365198491786976;0.111966162764340;0.00630038819500370;-0.151556440405286;0.423893230425844;0.0540864545337246;0.125078788352218;0.0499421589240168;0.0437567616231233;-0.0903901987714258;0.0115955202984062;-0.435188484468931;0.204083750042502;0.0496705413118758;0.141282824625690;-0.0897458327105212;-0.0890659947706586;-0.0744618380266183;-0.145806936673113;0.198673443112599;-0.751162855327961;0.0352517406972424;-0.213342664183442;-0.0828953298182462;-0.148440495128912;0.378987720939491;-0.127472458996247;-0.0197592548429296;0.217961841105270;0.0394594712470257;0.265508675768881;0.214910086509695;0.524313104052627;-0.0449890797665015;0.294065966166782;0.334148819720121;-0.0656662371655397;-0.270035991079947;-0.234737604548230;0.116467415656063;-0.621033035092737;0.505088039887979;-0.210156826206909;0.523987989910982;0.190853886812503;-0.320677823829533;0.330652309405845;0.0707033329346852;0.389341521364255];

% absolwenci: -46444.0499
B_backup = [0.635499062183167;0.802574950401142;0.0615200392820101;0.0808398747917190;-0.216930973461307;-0.248959981232869;0.0486927128092550;-0.255403900121180;-0.546285613952123;0.220467156077207;0.656743923156360;0.974375048622245;0.00409841266010563;0.0771180479201926;-0.0246310439620545;-0.183590470653828;-0.312445390412778;0.0951015183409455;0.0734850023482607;-0.181870924714593;0.340001552433709;0.0309615770205548;0.00981220808178033;-0.00256637662999998;-0.00202987059819753;-0.185654631451261;0.00925941864033835;-0.549288904386261;0.153024931157644;0.0354061799725851;0.00250781843377697;0.198689925442363;0.0748634932043271;0.228507460683799;-0.288211504394178;0.417912174605194;-0.329339570685803;0.0617957303446227;-0.0229067573340175;0.192854129665326;0.309982685441667;-0.122278099966143;-0.217296738644654;-0.342464990361870;0.192373870420363;0.188563855889130;0.107526379269149;0.241542780975145;-0.136724887547062;0.683431925076992;0.0980480219953882;0.0799933041906542;0.298137796986475;0.0540387883271641;-0.0265427152855973;0.132813000917291;-0.0133908118416624;0.303538894830760;0.0949751467062477;0.617164294464973;-0.0202795097281683;-0.362326620247628;0.449255256508133;-0.0573765542356611;0.222305125743327];

Results.MXL = MXL(INPUT,Results,EstimOpt,OptimOpt);

