% Choosing the future: economic preferences for higher education using discrete choice experiment method
% Estimation of the Latent Class model:

clear all
clc

global B_backup; % this one is for storing B in case iterations are interrupted with ctrl-c


%% ****************************  loading data  ****************************


DATA = load('EDU2_DCE_01.mat');
DATA_SD = load('edu2_data_sd_all.mat');


%% ****************************  data transformations  ****************************


DATA.odl = zeros(size(DATA.ANS));
DATA.odl(DATA.O==1) = 15;
DATA.odl(DATA.O==2) = 65;
DATA.odl(DATA.O==3) = 175;
DATA.odl(DATA.O==4) = 250;
DATA.odl = DATA.odl / 100;

DATA.female = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.PLEC-1); % 0.4913

DATA.age = vlookup(DATA.RESPID, DATA_SD.RESPID, 2014 - DATA_SD.S1); % 0.4913

DATA.children = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.Z3_X);
DATA.children(isnan(DATA.children)) = 0;

DATA_SD.oceny1 = [DATA_SD.B17_01,DATA_SD.B17_03,DATA_SD.B17_04,DATA_SD.B17_05,DATA_SD.B17_06,DATA_SD.B17_07,DATA_SD.B17_08,DATA_SD.B17_09,DATA_SD.B17_10,DATA_SD.B17_11,DATA_SD.B17_12,DATA_SD.B17_13,DATA_SD.B17_14,DATA_SD.B17_15,DATA_SD.B17_16,DATA_SD.B17_17,DATA_SD.B17_18,DATA_SD.B17_21,DATA_SD.B17_22,DATA_SD.B17_23,DATA_SD.B17_24,DATA_SD.B17_25,DATA_SD.B17_26];
DATA_SD.oceny1(DATA_SD.oceny1 == 6) = 0.95;
DATA_SD.oceny1(DATA_SD.oceny1 == 5) = 0.825;
DATA_SD.oceny1(DATA_SD.oceny1 == 4) = 0.675;
DATA_SD.oceny1(DATA_SD.oceny1 == 3) = 0.525;
DATA_SD.oceny1(DATA_SD.oceny1 == 2) = 0.375;
DATA_SD.oceny1(DATA_SD.oceny1 == 1) = 0.15;
DATA_SD.oceny2 = [DATA_SD.B17A_01,DATA_SD.B17A_03,DATA_SD.B17A_04,DATA_SD.B17A_05,DATA_SD.B17A_06,DATA_SD.B17A_07,DATA_SD.B17A_08,DATA_SD.B17A_09,DATA_SD.B17A_10,DATA_SD.B17A_11,DATA_SD.B17A_12,DATA_SD.B17A_13,DATA_SD.B17A_14,DATA_SD.B17A_15,DATA_SD.B17A_16,DATA_SD.B17A_17,DATA_SD.B17A_18,DATA_SD.B17A_21,DATA_SD.B17A_22,DATA_SD.B17A_23,DATA_SD.B17A_24,DATA_SD.B17A_25,DATA_SD.B17A_26];
DATA_SD.oceny2(DATA_SD.oceny2 == 6) = 0.95;
DATA_SD.oceny2(DATA_SD.oceny2 == 5) = 0.825;
DATA_SD.oceny2(DATA_SD.oceny2 == 4) = 0.675;
DATA_SD.oceny2(DATA_SD.oceny2 == 3) = 0.525;
DATA_SD.oceny2(DATA_SD.oceny2 == 2) = 0.375;
DATA_SD.oceny2(DATA_SD.oceny2 == 1) = 0.15;
DATA_SD.oceny3 = [DATA_SD.B17A_01,DATA_SD.B17A_03,DATA_SD.B17A_04,DATA_SD.B17A_05,DATA_SD.B17A_06,DATA_SD.B17A_07,DATA_SD.B17A_08,DATA_SD.B17A_09,DATA_SD.B17A_10,DATA_SD.B17A_11,DATA_SD.B17A_12,DATA_SD.B17A_13,DATA_SD.B17A_14,DATA_SD.B17A_15,DATA_SD.B17A_16,DATA_SD.B17A_17,DATA_SD.B17A_18,DATA_SD.B17A_21,DATA_SD.B17A_22,DATA_SD.B17A_23,DATA_SD.B17A_24,DATA_SD.B17A_25,DATA_SD.B17A_26];
DATA_SD.oceny3(DATA_SD.oceny3 == 1) = 0.95;
DATA_SD.oceny3(DATA_SD.oceny3 == 2) = 0.825;
DATA_SD.oceny3(DATA_SD.oceny3 == 3) = 0.675;
DATA_SD.oceny3(DATA_SD.oceny3 == 4) = 0.525;
DATA_SD.oceny3(DATA_SD.oceny3 == 5) = 0.375;
DATA_SD.oceny3(DATA_SD.oceny3 == 6) = 0.30;
DATA_SD.oceny3(DATA_SD.oceny3 == 7) = 0.15;

DATA_SD.wynik_sr  = nanmean([DATA_SD.oceny1,DATA_SD.oceny2,DATA_SD.oceny3],2);
DATA_SD.wynik_sr_NaN = isnan(DATA_SD.wynik_sr);
DATA.wynik_sr_org = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.wynik_sr);
DATA_SD.wynik_sr(DATA_SD.wynik_sr_NaN) = 0;

DATA.wynik_sr = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.wynik_sr);
DATA.wynik_sr_NaN = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.wynik_sr_NaN);

DATA_SD.koszt_akt = DATA_SD.PP1_2C;
DATA_SD.koszt_akt_NaN = DATA_SD.koszt_akt > 6 | isnan(DATA_SD.koszt_akt);
DATA.koszt_akt_org = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.koszt_akt);
DATA_SD.koszt_akt(DATA_SD.koszt_akt_NaN) = 0;
DATA_SD.koszt_akt(DATA_SD.koszt_akt == 1) = -3;
DATA_SD.koszt_akt(DATA_SD.koszt_akt == 2) = -1;
DATA_SD.koszt_akt(DATA_SD.koszt_akt == 3) = 0;
DATA_SD.koszt_akt(DATA_SD.koszt_akt == 4) = 3;
DATA_SD.koszt_akt(DATA_SD.koszt_akt == 6) = 7;
DATA.koszt_akt = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.koszt_akt);
DATA.koszt_akt_NaN = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.koszt_akt_NaN);

DATA_SD.wyn_akt = DATA_SD.PP2_2C;
DATA.wyn_akt_org = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.wyn_akt);
DATA_SD.wyn_akt_NaN = DATA_SD.wyn_akt > 5 | isnan(DATA_SD.wyn_akt);
DATA_SD.wyn_akt(DATA_SD.wyn_akt_NaN) = 0;
DATA_SD.wyn_akt(DATA_SD.wyn_akt == 5) = 8;
DATA_SD.wyn_akt(DATA_SD.wyn_akt == 4) = 6;
DATA_SD.wyn_akt(DATA_SD.wyn_akt == 3) = 4;
DATA_SD.wyn_akt(DATA_SD.wyn_akt == 2) = 3;
DATA_SD.wyn_akt(DATA_SD.wyn_akt == 1) = 2;
DATA.wyn_akt = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.wyn_akt);
DATA.wyn_akt_NaN = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.wyn_akt_NaN);

DATA_SD.odl_akt = DATA_SD.PP4_2C;
DATA.odl_akt_org = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.odl_akt);
DATA_SD.odl_akt_NaN = DATA_SD.wyn_akt > 4 | isnan(DATA_SD.odl_akt);
DATA_SD.odl_akt(DATA_SD.odl_akt_NaN) = 0;
DATA_SD.odl_akt(DATA_SD.odl_akt == 4) = 2.5;
DATA_SD.odl_akt(DATA_SD.odl_akt == 3) = 1.75;
DATA_SD.odl_akt(DATA_SD.odl_akt == 2) = 0.65;
DATA_SD.odl_akt(DATA_SD.odl_akt == 1) = 0.15;
DATA.odl_akt = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.odl_akt);
DATA.odl_akt_NaN = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.odl_akt_NaN);

DATA_SD.rank_akt = DATA_SD.PP5_2C;
DATA.rank_akt_org = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.rank_akt);
DATA_SD.rank_akt_NaN = DATA_SD.wyn_akt > 3 | isnan(DATA_SD.rank_akt);
DATA_SD.rank_akt(DATA_SD.rank_akt_NaN) = 0;
DATA.rank_akt = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.rank_akt);
DATA.rank_akt_NaN = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.rank_akt_NaN);

DATA.KLASYFIKACJA = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.KLASYFIKACJA);

DATA.sytmat_org = vlookup(DATA.RESPID, DATA_SD.RESPID, [DATA_SD.Z7A]);
DATA.sytmat = vlookup(DATA.RESPID, DATA_SD.RESPID, [DATA_SD.Z7A == 1, DATA_SD.Z7A == 2, DATA_SD.Z7A == 4, DATA_SD.Z7A == 5, isnan(DATA_SD.Z7A)]);

DATA.Z9 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.Z9);
DATA.Z91 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.Z9 == 1);
DATA.Z92 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.Z9 == 2);
DATA.Z93 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.Z9 == 3);
DATA.Z94 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.Z9 == 4);
DATA.Z95 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.Z9 == 5);
DATA.Z96 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.Z9 == 6);
DATA.Z97 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.Z9 == 7);
DATA.Z98 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.Z9 == 8);
DATA.Z9NaN = vlookup(DATA.RESPID, DATA_SD.RESPID, isnan(DATA_SD.Z9));

DATA.dropouts = DATA.KLASYFIKACJA == 6;
DATA.maturzysci = DATA.KLASYFIKACJA == 1;
DATA.studenci = any(DATA.KLASYFIKACJA == [2,3,4],2);
DATA.absolwenci = any(DATA.KLASYFIKACJA == [5,7,8,9,10],2);

DATA.pracuje = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.N1 == 1);
DATA.pracuje_godzin = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P2);
DATA.pracuje_godzin(isnan(DATA.pracuje_godzin)) = 0;
DATA.pracuje_godzin(DATA.pracuje_godzin == 9999) = NaN;
DATA.pracuje_godzin(DATA.pracuje_godzin == 9998) = NaN;
DATA.pracuje_godzin(isnan(DATA.pracuje_godzin)) = nanmean(DATA.pracuje_godzin(DATA.pracuje_godzin>0));
% dstats(DATA.pracuje_godzin)

DATA.zaint_01 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__01); % ekonomia, finanse, zarzdzanie, marketing
DATA.zaint_02 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__02); % prawo, administracja
DATA.zaint_03 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__03); % matematyka, informatyka, elektronika
DATA.zaint_04 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__04); % inynieria, mechanika, budownictwo
DATA.zaint_05 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__05); % historia, archeologia
DATA.zaint_06 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__06); % filologia, jzykoznawstwo, literaturoznawstwo
DATA.zaint_07 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__07); % socjologia, nauki polityczne, stosunki midzynarodowe
DATA.zaint_08 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__08); % psychologia, pedagogika
DATA.zaint_09 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__09); % fizyka, astronomia 
DATA.zaint_10 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__10); % chemia, biologia, nauki o rodowisku
DATA.zaint_11 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__11); % rolnictwo, technologia ywnoci, lenictwo
DATA.zaint_12 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__12); % medycyna, farmaceutyka
DATA.zaint_13 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__13); % kultura fizyczna, nauka o zdrowiu
DATA.zaint_14 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.P__14); % muzyka, sztuki pikne, sztuki projektowe

DATA.zaint_01_norm = DATA.zaint_01 - mean(DATA.zaint_01);
DATA.zaint_02_norm = DATA.zaint_02 - mean(DATA.zaint_02);
DATA.zaint_03_norm = DATA.zaint_03 - mean(DATA.zaint_03);
DATA.zaint_04_norm = DATA.zaint_04 - mean(DATA.zaint_04);
DATA.zaint_05_norm = DATA.zaint_05 - mean(DATA.zaint_05);
DATA.zaint_06_norm = DATA.zaint_06 - mean(DATA.zaint_06);
DATA.zaint_07_norm = DATA.zaint_07 - mean(DATA.zaint_07);
DATA.zaint_08_norm = DATA.zaint_08 - mean(DATA.zaint_08);
DATA.zaint_09_norm = DATA.zaint_09 - mean(DATA.zaint_09);
DATA.zaint_10_norm = DATA.zaint_10 - mean(DATA.zaint_10);
DATA.zaint_11_norm = DATA.zaint_11 - mean(DATA.zaint_11);
DATA.zaint_12_norm = DATA.zaint_12 - mean(DATA.zaint_12);
DATA.zaint_13_norm = DATA.zaint_13 - mean(DATA.zaint_13);
DATA.zaint_14_norm = DATA.zaint_14 - mean(DATA.zaint_14);

DATA.wies = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.KLASAWLK == 1); % wie
DATA.miasto_10_100 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.KLASAWLK > 1 & DATA_SD.KLASAWLK < 6); % miasto 10, 10-19, 20-49, 50-99 tys
DATA.miasto_100_500 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.KLASAWLK == 6 | DATA_SD.KLASAWLK == 7); % miasto 100-199, 200-499 tys
DATA.miasto_500 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.KLASAWLK == 8); % miasto 500+ tys
DATA.miasto_wawa = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.KLASAWLK == 9); % miasto Warszawa

ojciec_idx = [DATA_SD.Z10_01, DATA_SD.Z10_02, DATA_SD.Z10_03, DATA_SD.Z10_04, DATA_SD.Z10_08]==1;
for i = 1:5
    ojciec_idx(sum(ojciec_idx,2)>1,6-i) = 0;
end
matka_idx = [DATA_SD.Z10_01, DATA_SD.Z10_02, DATA_SD.Z10_03, DATA_SD.Z10_04, DATA_SD.Z10_08]==2;
for i = 1:5
    matka_idx(sum(matka_idx,2)>1,6-i) = 0;
end

DATA.w_ojca = vlookup(DATA.RESPID, DATA_SD.RESPID, nansum([DATA_SD.Z11_01, DATA_SD.Z11_02, DATA_SD.Z11_03, DATA_SD.Z11_04, DATA_SD.Z11_08].*ojciec_idx,2));
DATA.w_matki = vlookup(DATA.RESPID, DATA_SD.RESPID, nansum([DATA_SD.Z11_01, DATA_SD.Z11_02, DATA_SD.Z11_03, DATA_SD.Z11_04, DATA_SD.Z11_08].*matka_idx,2));
DATA.w_ojca(any(DATA.w_ojca == [0,6],2)) = NaN;
DATA.w_matki(any(DATA.w_matki == [0,6],2)) = NaN;

DATA.wyksz_rodz_max = max(DATA.w_ojca,DATA.w_matki);
DATA.wyksz_rodz_max_podst = DATA.wyksz_rodz_max < 3;
DATA.wyksz_rodz_max_sred = DATA.wyksz_rodz_max > 2 & DATA.wyksz_rodz_max < 5;
DATA.wyksz_rodz_max_wyz = DATA.wyksz_rodz_max == 5;

hh_idx = [DATA_SD.Z10_01, DATA_SD.Z10_02, DATA_SD.Z10_03, DATA_SD.Z10_04, DATA_SD.Z10_05, DATA_SD.Z10_06, DATA_SD.Z10_07, DATA_SD.Z10_08];
DATA_SD.HHsize = 8 - sum(isnan(hh_idx),2) + 1;
DATA.HHsize = vlookup(DATA.RESPID, DATA_SD.RESPID,DATA_SD.HHsize);

clear hh_idx matka_idx ojciec_idx

DATA.wiek_1819 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.S1_A==1);
DATA.wiek_1920 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.S1_A==2);
DATA.wiek_2122 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.S1_A==3);
DATA.wiek_2324 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.S1_A==4);
DATA.wiek_2526 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.S1_A==5);
DATA.wiek_2728 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.S1_A==6);
DATA.wiek_2930 = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.S1_A==7);
DATA.wiek_rozp_norm = DATA.wiek_1819*18.5 + DATA.wiek_1920*19.5 + DATA.wiek_2122*21.5 + DATA.wiek_2324*23.5 + DATA.wiek_2526*25.5 + DATA.wiek_2728*27.5 + DATA.wiek_2930*29.5;
DATA.wiek_rozp_norm = DATA.wiek_rozp_norm - nanmean(DATA.wiek_rozp_norm);

DATA_SD.A11A_1(DATA_SD.A11A_1 > 2017) = NaN;
DATA.rok_rozp = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.A11A_1);
DATA.rok_rozp_norm = DATA.rok_rozp - nanmean(DATA.rok_rozp);

DATA_SD.Z7A(DATA_SD.Z7A == 98) = NaN;

DATA.syt_mat = vlookup(DATA.RESPID, DATA_SD.RESPID, DATA_SD.Z7A);
DATA.syt_mat_norm = DATA.syt_mat - nanmean(DATA.syt_mat);

DATA.K0 = max(DATA.K,0);
DATA.S = -min(DATA.K,0);


%% ****************************  model specification  ****************************


DATA.Y = DATA.ANS;

DATA.Xa = [DATA.Z==2,DATA.Z==3,DATA.J==2,DATA.J==1,DATA.odl,DATA.S==1,DATA.S==3,DATA.D,DATA.W/4,-DATA.K0/4];
EstimOpt.NamesA = {'zgodnosc_srednia (vs. niska)';'zgodnosc_wysoka (vs. niska)';'jakosc_srednia (vs. niska)';'jakosc_wysoka (vs. niska)';'odleglosc / 100 (0;2.5)';'stypendium (250 EUR)';'stypendium (750 EUR)';'dzienne (vs. zaoczne)';'wynagrodzenie (2;8)/4';'-koszt (0;7)/4'}; % Specyfy names of the attributes

DATA.Xm = [DATA.dropouts, DATA.maturzysci, DATA.studenci, DATA.pracuje, DATA.pracuje_godzin, ...
    DATA.zaint_02_norm, DATA.zaint_03_norm, DATA.zaint_04_norm, DATA.zaint_05_norm, DATA.zaint_06_norm, DATA.zaint_07_norm, DATA.zaint_08_norm, DATA.zaint_09_norm, DATA.zaint_10_norm, DATA.zaint_11_norm, DATA.zaint_12_norm, DATA.zaint_13_norm, DATA.zaint_14_norm, ...
    DATA.wies, DATA.miasto_10_100, DATA.miasto_500, DATA.miasto_wawa,...
    DATA.wyksz_rodz_max_podst, DATA.wyksz_rodz_max_wyz, ...
    DATA.syt_mat_norm, DATA.HHsize, DATA.female];
    
EstimOpt.NamesM = {'dropouts (vs. absolwenci)', 'maturzy?ci (vs. absolwenci)', 'studenci (vs. absolwenci)', 'pracuje', 'pracuje godzin', ...
'prawo (vs ekonomia)', 'matematyka','inynieria','historia','filologia','socjologia','psychologia','fizyka','rodowisko','rolnictwo','medycyna','kultura fizyczna','sztuka',...
'wie','miasto 10-100k', 'miasto 500k+','miasto wawa',...
'wykszt. rodz. podst.', 'wykszt. rodz. wysze',...
'sytuacja materialna 1-5 norm.','wielk. gosp. dom.', 'kobieta'};

DATA.Xc = DATA.Xm;
EstimOpt.NamesC = EstimOpt.NamesM;


%% ****************************  specifying input ****************************

DATA.filter = ones(size(DATA.Y))==1 & ~any(isnan(DATA.Xc),2); % DATA.absolwenci;%

INPUT.Y = DATA.Y(DATA.filter);
INPUT.Xa = DATA.Xa(DATA.filter,:);
% INPUT.Xm = DATA.Xm(DATA.filter,:);
INPUT.Xc = DATA.Xc(DATA.filter,:);


%% ****************************  sample characteristics ****************************


EstimOpt.NCT = 12; % Number of choice tasks per person 
EstimOpt.NAlt = 3; % Number of alternatives
EstimOpt.NP = length(INPUT.Y)/EstimOpt.NCT/EstimOpt.NAlt; % numel(unique(DATA.nr))


%% **************************** estimation and optimization options ****************************


EstimOpt.eps = 1.e-12; % overall precision level

[INPUT, Results, EstimOpt, OptimOpt] = DataCleanDCE(INPUT,EstimOpt);

EstimOpt.NRep = 1e4; % number of draws for numerical simulation
% OptimOpt.MaxIter = 100; % maximum number of iterations

% OptimOpt.Algorithm = 'trust-region'; % 'quasi-newton';
% EstimOpt.NumGrad = 1; % 1
% OptimOpt.GradObj = 'on'; % 'off'
% OptimOpt.FinDiffType = 'central'; % 'forward'
% OptimOpt.Hessian = 'user-supplied'; % 'off'
% EstimOpt.HessEstFix = 1; % 0 = use optimization Hessian, 1 = use jacobian-based (BHHH) Hessian, 2 - use high-precision jacobian-based (BHHH) Hessian 3 - use numerical Hessian
% EstimOpt.ApproxHess = 0;

EstimOpt.ProjectName = 'LC4';


%% ****************************     MNL     ****************************

B_backup = [0.395476046085632;0.563558520401435;0.0626648194512185;0.0888498606791792;-0.194555265508847;0.145560655647526;-0.234161566879073;0.660502681417773;0.881036494091599];

Results.MNL = MNL(INPUT,Results,EstimOpt,OptimOpt);


%% ****************************     LC     ****************************

EstimOpt.NClass = 4;

B_backup = [0.504138478268576;0.125994048570631;-0.0311301813002734;-0.0530182757183764;-0.0868505065546900;-0.100761333181767;0.277306902617451;-0.264933509666521;2.25412137512371;0.751468018722342;0.459685245676682;0.415402809281093;0.116222914832635;0.155247348227548;-0.159245615247438;-0.0863226517990581;0.0690801683243638;-0.323426737904497;1.06173662198484;2.59448818666086;0.631253631067440;0.937764745790284;0.130258413985843;0.0329023454941038;-0.335056076232039;-0.320296126514200;-0.0714532856252562;-2.57797353281537;0.559345845620134;0.950346285154948;0.463762672325173;0.746030218181229;0.0411472924145914;0.0799820723752589;-0.224169788988906;-0.0839242311769404;-0.000445696800088427;0.0899549436711239;0.301999596868355;0.510464616790967;-1.50737609082551;0.138461528019951;-0.314574171281919;-0.0304819685328311;-0.115037070075398;0.00704840669832134;-0.0402581438201267;0.0621187574168811;0.0270359456506197;-0.114816059784029;0.0510824045351665;0.00155184357183643;-0.0647884214840185;-0.0357584222037769;-0.0235274880850835;0.0209901059411616;-0.0705421315086731;-0.0169504793265587;-0.135229816403999;0.168374873504430;0.0324727984728797;0.168113591810475;0.0632195934630185;0.0185376553541259;0.486728995354949;-0.100754911982675;-0.0445214117429466;-0.198455513264232;-0.873624692791182;0.192122167723787;0.115890957605222;-0.176856650161069;0.0260808719389618;0.000363949098014930;-0.0667981025038464;-0.0290248153293957;-0.0870424336659305;-0.0572486754924081;-0.0161223700213438;-0.0342314655347083;-0.0676356027045242;-0.133538484706794;-0.0330376296572132;-0.0131132775878978;-0.0712758145388070;0.0179986240760708;-0.0737599720015965;0.233642579257124;0.204436221563364;0.0910685562211899;0.428426738707873;0.280516561940625;-0.0584648229153481;-0.0832474304543334;0.0168691970252926;-0.0179846624161663;-3.23109820369595;0.139288621340066;0.569424197331741;0.0651008598678272;0.472910542521400;0.00881209192313766;0.0268173029753753;0.0340816929352565;-0.0689418670866885;-0.0324752446328011;-0.0705962415040897;-0.0293652133331821;0.0828803158152172;-0.238567246735953;-0.0696845809017398;-0.0276969649809067;-0.0947377709690995;0.0388562576836845;-0.0752262738641274;0.270418050481602;0.278529341388288;-0.322163330572583;-0.605695260263567;0.373304529430379;-0.117336278518033;-0.0323239933584519;0.165489385687786;0.121778437335340];

Results.LC = LC(INPUT,Results,EstimOpt,OptimOpt);
